/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.consumer;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.exception.SubscriptionOffsetResetException;
import com.aliyun.datahub.client.model.JoinGroupResult;
import com.aliyun.datahub.clientlibrary.config.ConsumerConfig;
import com.aliyun.datahub.clientlibrary.consumer.Heartbeat;
import com.aliyun.datahub.clientlibrary.exception.ExceptionRetryer;
import com.aliyun.datahub.clientlibrary.models.Assignment;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(ShardCoordinator.class);
    private String projectName;
    private String topicName;
    private String subId;
    private String consumerId;
    private long versionId;
    private ConsumerConfig config;
    private DatahubClient client;
    private Heartbeat heartbeat;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ShardCoordinator(String projectName, String topicName, String subId, ConsumerConfig config, DatahubClient client) {
        this.config = config;
        this.projectName = projectName;
        this.topicName = topicName;
        this.subId = subId;
        this.client = client;
        this.heartbeat = new Heartbeat(client, projectName, topicName, subId);
        this.init();
    }

    void syncGroup(List<String> readEndShardList) {
        if (!this.heartbeat.checkRunning()) {
            return;
        }
        if (!this.heartbeat.updateReadEndShardList(readEndShardList)) {
            return;
        }
        try {
            this.client.syncGroup(this.projectName, this.topicName, this.subId, this.consumerId, this.versionId, Collections.emptyList(), readEndShardList);
            LOG.info("Sync group success, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, ReadEndShardList: {}", new Object[]{this.projectName, this.topicName, this.subId, this.consumerId, readEndShardList.toString()});
        }
        catch (ResourceNotFoundException e) {
            LOG.warn("Stop heartbeat and rejoin group, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{this.projectName, this.topicName, this.subId, this.consumerId, e});
            this.heartbeat.stop();
        }
        catch (SubscriptionOffsetResetException e) {
            LOG.warn("Sync group failed, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{this.projectName, this.topicName, this.subId, this.consumerId, e});
            throw e;
        }
        catch (DatahubClientException e) {
            LOG.warn("Sync group failed, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, Exception: {}", new Object[]{this.projectName, this.topicName, this.subId, this.consumerId, e.getMessage()});
        }
    }

    String getConsumerId() {
        return this.consumerId;
    }

    boolean rejoinIfNeeded() {
        if (this.heartbeat.checkRunning()) {
            return false;
        }
        try {
            this.joinGroup();
            return true;
        }
        catch (DatahubClientException e) {
            if (!ExceptionRetryer.canSwallow(e)) {
                throw e;
            }
            return false;
        }
    }

    void leaveGroup() {
        if (this.heartbeat != null) {
            try {
                boolean inGroup = this.heartbeat.checkRunning();
                this.heartbeat.stop();
                if (inGroup) {
                    this.client.leaveGroup(this.projectName, this.topicName, this.subId, this.consumerId, this.versionId);
                    LOG.info("Auto leave group, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{this.projectName, this.topicName, this.subId, this.getConsumerId()});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.leaveGroup();
        }
    }

    Assignment getNewAssignment() {
        return this.heartbeat.getAssignment();
    }

    private void joinGroup() {
        new ExceptionRetryer<Void>(){

            @Override
            protected Void func() {
                JoinGroupResult joinGroupResult = ShardCoordinator.this.client.joinGroup(ShardCoordinator.this.projectName, ShardCoordinator.this.topicName, ShardCoordinator.this.subId, ShardCoordinator.this.config.getSessionTimeoutMs());
                ShardCoordinator.this.consumerId = joinGroupResult.getConsumerId();
                ShardCoordinator.this.versionId = joinGroupResult.getVersionId();
                long heartbeatIntervalMs = (long)((float)joinGroupResult.getSessionTimeout() * 0.66f);
                ShardCoordinator.this.heartbeat.start(ShardCoordinator.this.consumerId, ShardCoordinator.this.versionId, heartbeatIntervalMs);
                LOG.info("Join group success, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, VersionId: {}, SessionTimeout: {}", new Object[]{ShardCoordinator.this.projectName, ShardCoordinator.this.topicName, ShardCoordinator.this.subId, ShardCoordinator.this.consumerId, ShardCoordinator.this.versionId, joinGroupResult.getSessionTimeout()});
                return null;
            }

            @Override
            protected void onExceedRetryLimit(DatahubClientException e) {
                LOG.error("Join group failed, Project: {}, Topic: {}, SubId: {}", new Object[]{ShardCoordinator.this.projectName, ShardCoordinator.this.topicName, ShardCoordinator.this.subId, e});
            }

            @Override
            protected boolean isTerminated() {
                return ShardCoordinator.this.closed.get();
            }
        }.run(3, 1000L);
    }

    private void init() {
        try {
            this.joinGroup();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }
}

