/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.consumer;

import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.clientlibrary.common.ClientHelper;
import com.aliyun.datahub.clientlibrary.config.ConsumerConfig;
import com.aliyun.datahub.clientlibrary.consumer.ShardReader;
import com.aliyun.datahub.clientlibrary.exception.ClientException;
import com.aliyun.datahub.clientlibrary.interceptor.ReadInterceptor;
import com.aliyun.datahub.clientlibrary.models.Assignment;
import com.aliyun.datahub.clientlibrary.models.Offset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardGroupReader {
    private static final Logger LOG = LoggerFactory.getLogger(ShardGroupReader.class);
    private ConsumerConfig config;
    private ClientHelper clientHelper;
    private boolean ownClientManager = false;
    private String projectName;
    private String topicName;
    private String subId;
    private ShardReaderPicker shardReaderPicker = new ShardReaderPicker();
    private final Map<String, ShardReader> shardReaderMap = new HashMap<String, ShardReader>();
    private final Map<String, Long> readEndSeqMap = new HashMap<String, Long>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final Object emptyCond = new Object();
    private final ReadInterceptor interceptor;

    public ShardGroupReader(String projectName, String topicName, ConsumerConfig config) {
        try {
            this.ownClientManager = true;
            this.clientHelper = new ClientHelper(projectName, topicName, config);
            this.projectName = projectName;
            this.topicName = topicName;
            this.config = config;
            this.interceptor = config.getInterceptorBuilder().buildReadInterceptor();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public RecordEntry read() {
        this.checkNotClosed();
        int maxRetry = this.shardReaderMap.size();
        for (int retry = 0; retry < maxRetry; ++retry) {
            ShardReader shardReader = this.shardReaderPicker.pick();
            if (shardReader == null) {
                return null;
            }
            RecordEntry record = shardReader.read();
            if (record != null) {
                return record;
            }
            if (!shardReader.isReadEnd()) continue;
            this.readEndSeqMap.put(shardReader.getShardId(), shardReader.getEndSequence());
        }
        return null;
    }

    public void createShardReader(Map<String, Offset> offsetMap) {
        this.createShardReader(offsetMap, true);
    }

    public void removeShardReader(List<String> shardIds) {
        this.checkNotClosed();
        for (String shardId : shardIds) {
            ShardReader shardReader = this.shardReaderMap.get(shardId);
            if (shardReader == null) continue;
            shardReader.close();
            this.shardReaderMap.remove(shardId);
            this.readEndSeqMap.remove(shardId);
        }
    }

    public Set<String> getShards() {
        return this.shardReaderMap.keySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            block7: {
                this.removeAllShardReader();
                this.executor.shutdown();
                try {
                    this.executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
                    if (this.executor.isShutdown()) break block7;
                }
                catch (InterruptedException interruptedException) {
                    if (!this.executor.isShutdown()) {
                        LOG.info("ShardReaderGroup close timeout, shutdown now, Project: {}, Topic: {}, SubId: {}", new Object[]{this.projectName, this.topicName, this.subId});
                        this.executor.shutdownNow();
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    if (!this.executor.isShutdown()) {
                        LOG.info("ShardReaderGroup close timeout, shutdown now, Project: {}, Topic: {}, SubId: {}", new Object[]{this.projectName, this.topicName, this.subId});
                        this.executor.shutdownNow();
                    }
                    throw throwable;
                }
                LOG.info("ShardReaderGroup close timeout, shutdown now, Project: {}, Topic: {}, SubId: {}", new Object[]{this.projectName, this.topicName, this.subId});
                this.executor.shutdownNow();
            }
            if (this.ownClientManager && this.clientHelper != null) {
                this.clientHelper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSignal(long timeout) {
        Object object = this.emptyCond;
        synchronized (object) {
            if (!this.closed.get()) {
                try {
                    this.emptyCond.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void removeAllShardReader() {
        for (ShardReader shardReader : this.shardReaderMap.values()) {
            shardReader.close();
        }
        this.shardReaderMap.clear();
    }

    ShardGroupReader(String projectName, String topicName, ConsumerConfig config, ClientHelper clientHelper) {
        this.projectName = projectName;
        this.topicName = topicName;
        this.config = config;
        this.clientHelper = clientHelper;
        this.interceptor = config.getInterceptorBuilder().buildReadInterceptor();
    }

    void createShardReader(Map<String, Offset> offsetMap, boolean syncInit) {
        this.checkNotClosed();
        for (String shardId : offsetMap.keySet()) {
            ShardReader shardReader = this.shardReaderMap.get(shardId);
            if (shardReader != null && !shardReader.isClosed()) continue;
            shardReader = new ShardReader(this.projectName, this.topicName, shardId, offsetMap.get(shardId), this.config, this.executor, this.clientHelper, this.emptyCond, this.interceptor);
            shardReader.setSubId(this.subId);
            if (syncInit) {
                shardReader.initCursor();
            }
            this.shardReaderMap.put(shardId, shardReader);
        }
    }

    void removeShardReader(Assignment assignment) {
        this.removeShardReader(assignment.getReleaseShardList(this.getShards()));
    }

    void setSubId(String subId) {
        this.subId = subId;
    }

    Map<String, Long> getEndSeqMap() {
        return this.readEndSeqMap;
    }

    private void checkNotClosed() {
        if (this.closed.get()) {
            LOG.error("This shard group reader has already been closed, Project: {}, Topic: {}, SubId: {}", new Object[]{this.projectName, this.topicName, this.subId});
            throw new ClientException("This shard group reader has already been closed");
        }
    }

    private class ShardReaderPicker {
        private final Set<ShardReader> emptySet = new HashSet<ShardReader>();

        private ShardReaderPicker() {
        }

        ShardReader pick() {
            ShardReader result = this.findOldest();
            if (result != null) {
                if (result.frontRecordTime() == Long.MIN_VALUE) {
                    this.emptySet.add(result);
                }
                if (this.emptySet.size() >= ShardGroupReader.this.shardReaderMap.size() || result.frontRecordTime() != Long.MIN_VALUE) {
                    this.emptySet.clear();
                }
            }
            return result;
        }

        private ShardReader findOldest() {
            ShardReader result = null;
            for (ShardReader shardReader : ShardGroupReader.this.shardReaderMap.values()) {
                if (this.emptySet.contains(shardReader) || result != null && shardReader.frontRecordTime() >= result.frontRecordTime()) continue;
                result = shardReader;
            }
            return result;
        }
    }
}

