/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.example;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.exception.SubscriptionOfflineException;
import com.aliyun.datahub.client.exception.SubscriptionOffsetResetException;
import com.aliyun.datahub.client.exception.SubscriptionSessionInvalidException;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.TupleRecordData;
import com.aliyun.datahub.clientlibrary.config.ConsumerConfig;
import com.aliyun.datahub.clientlibrary.consumer.Consumer;
import com.aliyun.datahub.clientlibrary.models.Offset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ConsumerExample {
    private static final String TEST_ENDPOINT = "**datahub endpoint**";
    private static final String TEST_PROJECT = "** datahub project **";
    private static final String TEST_TOPIC = "** datahub tuple topic **";
    private static final String TEST_SUB_ID = "** subscription id **";
    private static final String TEST_AK = "** access id **";
    private static final String TEST_SK = "** access key **";
    private static final List<String> TEST_ASSIGNMENT = Arrays.asList("0", "1", "2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumeAutoAssigned() {
        block14: {
            ConsumerConfig config = new ConsumerConfig(TEST_ENDPOINT, TEST_AK, TEST_SK);
            config.getHttpConfig().setDebugRequest(true);
            Consumer consumer = new Consumer(TEST_PROJECT, TEST_TOPIC, TEST_SUB_ID, config);
            boolean stop = false;
            block12: while (true) {
                try {
                    while (!stop) {
                        try {
                            ConsumerExample.consume(consumer);
                        }
                        catch (SubscriptionOffsetResetException e) {
                            try {
                                Consumer newConsumer = new Consumer(TEST_PROJECT, TEST_TOPIC, TEST_SUB_ID, config);
                                consumer.close();
                                consumer = newConsumer;
                                continue block12;
                            }
                            catch (DatahubClientException datahubClientException) {
                            }
                        }
                        catch (InvalidParameterException | SubscriptionOfflineException | SubscriptionSessionInvalidException e) {
                            throw e;
                        }
                        catch (DatahubClientException e) {
                            try {
                                Thread.sleep(1000L);
                                continue block12;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    break block14;
                }
            }
            finally {
                consumer.close();
            }
        }
    }

    public static void consumeByShards() {
        ConsumerConfig config = new ConsumerConfig(TEST_ENDPOINT, TEST_AK, TEST_SK);
        Consumer consumer = new Consumer(TEST_PROJECT, TEST_TOPIC, TEST_SUB_ID, TEST_ASSIGNMENT, config);
        boolean stop = false;
        while (!stop) {
            try {
                ConsumerExample.consume(consumer);
            }
            catch (SubscriptionOffsetResetException | SubscriptionSessionInvalidException e) {
                consumer.close();
                consumer = new Consumer(TEST_PROJECT, TEST_TOPIC, TEST_SUB_ID, TEST_ASSIGNMENT, config);
            }
            catch (InvalidParameterException | ResourceNotFoundException throwable) {
            }
            catch (DatahubClientException datahubClientException) {}
        }
        consumer.close();
    }

    public static void consumeByOffset() {
        ConsumerConfig config = new ConsumerConfig(TEST_ENDPOINT, TEST_AK, TEST_SK);
        HashMap<String, Offset> offsetMap = new HashMap<String, Offset>();
        offsetMap.put("0", new Offset(100L, 1548573440756L));
        offsetMap.put("1", new Offset().setSequence(1L));
        offsetMap.put("2", new Offset().setTimestamp(1548573440756L));
        Consumer consumer = new Consumer(TEST_PROJECT, TEST_TOPIC, TEST_SUB_ID, offsetMap, config);
        boolean stop = false;
        while (!stop) {
            try {
                ConsumerExample.consume(consumer);
            }
            catch (SubscriptionOffsetResetException | SubscriptionSessionInvalidException e) {
                consumer.close();
                consumer = new Consumer(TEST_PROJECT, TEST_TOPIC, TEST_SUB_ID, offsetMap, config);
            }
            catch (InvalidParameterException | ResourceNotFoundException throwable) {
            }
            catch (DatahubClientException datahubClientException) {}
        }
        consumer.close();
    }

    private static void consume(Consumer consumer) {
        int maxRetry = 3;
        while (true) {
            RecordEntry record;
            if ((record = consumer.read(maxRetry)) != null) {
                TupleRecordData data = (TupleRecordData)record.getRecordData();
                System.out.println("field1:" + data.getField(0) + ", field2:" + data.getField("field2"));
            } else {
                System.out.println("record is null");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            record.getKey().ack();
        }
    }

    public static void main(String[] args) {
        ConsumerExample.consumeAutoAssigned();
        ConsumerExample.consumeByShards();
        ConsumerExample.consumeByOffset();
    }
}

