/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.example;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.MalformedRecordException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.RecordData;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.TupleRecordData;
import com.aliyun.datahub.clientlibrary.config.ProducerConfig;
import com.aliyun.datahub.clientlibrary.producer.Producer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProducerExample {
    private static final String TEST_ENDPOINT = "**datahub endpoint**";
    private static final String TEST_PROJECT = "** datahub project **";
    private static final String TEST_TOPIC = "** datahub tuple topic **";
    private static final String TEST_AK = "** access id **";
    private static final String TEST_SK = "** access key **";
    private static final List<String> TEST_ASSIGNMENT = Arrays.asList("0", "1", "2");

    public static Producer autoAssignedProducer() {
        ProducerConfig config = new ProducerConfig(TEST_ENDPOINT, TEST_AK, TEST_SK);
        return new Producer(TEST_PROJECT, TEST_TOPIC, config);
    }

    public static Producer manualAssignedProducer() {
        ProducerConfig config = new ProducerConfig(TEST_ENDPOINT, TEST_AK, TEST_SK);
        return new Producer(TEST_PROJECT, TEST_TOPIC, TEST_ASSIGNMENT, config);
    }

    public static void produce(Producer producer) {
        RecordSchema schema = ProducerExample.getSchema();
        ArrayList<RecordEntry> records = new ArrayList<RecordEntry>();
        for (int i = 0; i < 10; ++i) {
            records.add(ProducerExample.genTupleData(schema));
        }
        int maxRetry = 3;
        while (true) {
            try {
                while (true) {
                    producer.send(records, maxRetry);
                }
            }
            catch (MalformedRecordException malformedRecordException) {
                continue;
            }
            catch (InvalidParameterException invalidParameterException) {
                continue;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                continue;
            }
            catch (DatahubClientException datahubClientException) {
                continue;
            }
            break;
        }
    }

    public static RecordSchema getSchema() {
        DatahubClient client = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig(TEST_ENDPOINT, (Account)new AliyunAccount(TEST_AK, TEST_SK))).build();
        return client.getTopic(TEST_PROJECT, TEST_TOPIC).getRecordSchema();
    }

    private static RecordEntry genTupleData(RecordSchema schema) {
        final TupleRecordData data = new TupleRecordData(schema);
        block8: for (Field field : schema.getFields()) {
            switch (field.getType()) {
                case STRING: {
                    data.setField(field.getName(), (Object)"string");
                    continue block8;
                }
                case BIGINT: {
                    data.setField(field.getName(), (Object)5L);
                    continue block8;
                }
                case DOUBLE: {
                    data.setField(field.getName(), (Object)0.0);
                    continue block8;
                }
                case TIMESTAMP: {
                    data.setField(field.getName(), (Object)123456789000000L);
                    continue block8;
                }
                case BOOLEAN: {
                    data.setField(field.getName(), (Object)true);
                    continue block8;
                }
                case DECIMAL: {
                    data.setField(field.getName(), (Object)new BigDecimal(10000.000001));
                    continue block8;
                }
            }
            throw new DatahubClientException("Unknown field type");
        }
        return new RecordEntry(){
            {
                this.addAttribute("partition", "ds=2016");
                this.setRecordData((RecordData)data);
            }
        };
    }

    public static void main(String[] args) {
        Producer producer = ProducerExample.manualAssignedProducer();
        ProducerExample.produce(producer);
        producer.close();
        producer = ProducerExample.autoAssignedProducer();
        ProducerExample.produce(producer);
        producer.close();
    }
}

