/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.exception;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.clientlibrary.common.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionRetryer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionRetryer.class);

    protected abstract T func();

    protected void onExceedRetryLimit(DatahubClientException e) {
    }

    protected boolean isTerminated() {
        return false;
    }

    public static boolean isFatalException(DatahubClientException e) {
        return Constants.FATAL_EXCEPTIONS.contains(((Object)((Object)e)).getClass());
    }

    public static boolean canRetry(DatahubClientException e) {
        return e.getHttpStatus() / 100 == 5 || !ExceptionRetryer.isFatalException(e) && !Constants.CAN_NOT_RETRY_EXCEPTIONS.contains(((Object)((Object)e)).getClass());
    }

    public static boolean canSwallow(DatahubClientException e) {
        return e == null || e.getHttpStatus() / 100 == 5 || "ShardNotReady".equalsIgnoreCase(e.getErrorCode()) || "ConsumerGroupInProcess".equalsIgnoreCase(e.getErrorCode());
    }

    public static void invalidUriProtect(DatahubClientException e) {
        if ("InvalidUriSpec".equals(e.getErrorCode())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw e;
        }
    }

    public final T run(int retryTimes, long intervalMs) {
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                return this.func();
            }
            catch (DatahubClientException e) {
                LOG.debug("Request failed, sleep and retry, Exception: {}", (Object)e.getMessage());
                if (i == retryTimes) {
                    this.onExceedRetryLimit(e);
                }
                if (i == retryTimes || !ExceptionRetryer.canRetry(e)) {
                    throw e;
                }
                ExceptionRetryer.invalidUriProtect(e);
                if (this.isTerminated()) break;
                if (intervalMs <= 0L) continue;
                try {
                    Thread.sleep(intervalMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new DatahubClientException("client closed");
    }
}

