/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.models;

import com.aliyun.datahub.client.model.SubscriptionOffset;

public class Offset {
    private String cursor = "null";
    private long sequence;
    private long timestamp;

    public Offset() {
        this(-1L, -1L);
    }

    public Offset(String cursor) {
        this.cursor = cursor;
    }

    public Offset(String cursor, long sequence, long timestamp) {
        this.cursor = cursor;
        this.sequence = sequence;
        this.timestamp = timestamp;
    }

    public Offset(long sequence, long timestamp) {
        this.sequence = sequence;
        this.timestamp = timestamp;
    }

    public Offset(SubscriptionOffset subscriptionOffset) {
        this.sequence = subscriptionOffset.getSequence();
        this.timestamp = subscriptionOffset.getTimestamp();
    }

    public long getSequence() {
        return this.sequence;
    }

    public Offset setSequence(long sequence) {
        this.sequence = sequence;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Offset setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Offset setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public boolean isInvalid() {
        return this.sequence < 0L && this.timestamp < 0L && (this.cursor == null || this.cursor.equals("null"));
    }

    public boolean hasSequence() {
        return this.sequence >= 0L;
    }

    public boolean hasTimestamp() {
        return this.timestamp >= 0L;
    }

    public boolean hasCursor() {
        return this.cursor != null && !this.cursor.equals("null");
    }

    public Offset next() {
        Offset nextOffset = new Offset(this.sequence >= 0L ? this.sequence + 1L : -1L, this.timestamp);
        if (this.hasCursor()) {
            StringBuilder sb = new StringBuilder(this.cursor);
            sb.setCharAt(this.cursor.length() - 1, '1');
            nextOffset.setCursor(sb.toString());
        }
        return nextOffset;
    }

    public String toString() {
        return "(" + this.sequence + ", " + this.timestamp + ")";
    }
}

