/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.models;

import com.aliyun.datahub.client.model.SubscriptionOffset;
import com.aliyun.datahub.clientlibrary.models.Offset;
import com.aliyun.datahub.clientlibrary.models.OffsetWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OffsetManager {
    private final Map<String, OffsetWrapper> heldOffsets = new ConcurrentHashMap<String, OffsetWrapper>();
    private final Map<String, OffsetWrapper> releasingOffsets = new ConcurrentHashMap<String, OffsetWrapper>();

    public Map<String, OffsetWrapper> getHeldOffsets() {
        return this.heldOffsets;
    }

    public Map<String, OffsetWrapper> getReleasingOffsets() {
        return this.releasingOffsets;
    }

    public void addOffsets(Map<String, SubscriptionOffset> offsets) {
        offsets.forEach((shardId, offset) -> {
            this.releasingOffsets.remove(shardId);
            this.heldOffsets.put((String)shardId, new OffsetWrapper((SubscriptionOffset)offset));
        });
    }

    public OffsetWrapper getHeldOffset(String shardId) {
        return this.heldOffsets.get(shardId);
    }

    public Map<String, SubscriptionOffset> getAckedOffsets() {
        return this.heldOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((OffsetWrapper)x.getValue()).getAckedOffset()));
    }

    public Map<String, SubscriptionOffset> getOffsetsToRelease() {
        return this.releasingOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((OffsetWrapper)x.getValue()).getAckedOffset()));
    }

    public void release(List<String> shardIds) {
        for (String shardId : shardIds) {
            OffsetWrapper wrapper = this.heldOffsets.remove(shardId);
            if (wrapper == null) continue;
            this.releasingOffsets.put(shardId, wrapper);
        }
    }

    public void removeReleased(Collection<String> shardIds) {
        shardIds.forEach(this.releasingOffsets::remove);
    }

    public void removeAll() {
        this.heldOffsets.clear();
        this.releasingOffsets.clear();
    }

    public List<String> getReleasedShardList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, OffsetWrapper> entry : this.releasingOffsets.entrySet()) {
            String shardId = entry.getKey();
            OffsetWrapper wrapper = entry.getValue();
            if (wrapper == null || !wrapper.getQueue().isEmpty() || wrapper.getAckedOffset().getSequence() != wrapper.getCommittedSequence()) continue;
            this.releasingOffsets.remove(shardId);
            result.add(shardId);
        }
        return result;
    }

    public boolean hasShardToRelease() {
        for (OffsetWrapper wrapper : this.releasingOffsets.values()) {
            if (!wrapper.getQueue().isEmpty() || wrapper.getAckedOffset().getSequence() == wrapper.getCommittedSequence()) continue;
            return true;
        }
        return false;
    }

    public List<String> getReadEndShardList(Map<String, Long> endSequenceMap) {
        return endSequenceMap.entrySet().stream().filter(e -> (Long)e.getValue() == -1L || this.heldOffsets.get(e.getKey()).getCommittedSequence() == ((Long)e.getValue()).longValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void setCommittedOffsets(Map<String, SubscriptionOffset> committedOffsets) {
        committedOffsets.forEach((shardId, offset) -> {
            OffsetWrapper offsetWrapper = this.heldOffsets.get(shardId);
            if (offsetWrapper != null) {
                offsetWrapper.setCommittedOffset(new Offset((SubscriptionOffset)offset));
            } else {
                offsetWrapper = this.releasingOffsets.get(shardId);
                if (offsetWrapper != null) {
                    offsetWrapper.setCommittedOffset(new Offset((SubscriptionOffset)offset));
                }
            }
        });
    }

    public Map<String, Offset> getCommittedOffsets() {
        return Stream.concat(this.heldOffsets.entrySet().stream(), this.releasingOffsets.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, x -> ((OffsetWrapper)x.getValue()).getCommittedOffset()));
    }
}

