/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.models;

import com.aliyun.datahub.client.model.SubscriptionOffset;
import com.aliyun.datahub.clientlibrary.models.Offset;
import com.aliyun.datahub.clientlibrary.models.RecordKeyImpl;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class OffsetWrapper {
    private volatile SubscriptionOffset ackedOffset;
    private volatile Offset committedOffset = new Offset();
    private final ConcurrentLinkedQueue<RecordKeyImpl> queue = new ConcurrentLinkedQueue();
    private volatile long lastUnReadySeq = -1L;
    private volatile long lastCheckTime = -1L;
    private final AtomicLong warningTimes = new AtomicLong(0L);
    private final Object checkLock = new Object();

    public OffsetWrapper(SubscriptionOffset offset) {
        this.ackedOffset = offset;
    }

    public SubscriptionOffset getAckedOffset() {
        return this.ackedOffset;
    }

    public void updateAckedOffset(SubscriptionOffset offset) {
        SubscriptionOffset temp = this.ackedOffset;
        offset.setSessionId(temp.getSessionId());
        offset.setVersionId(temp.getVersionId());
        this.ackedOffset = offset;
    }

    public Offset getCommittedOffset() {
        return this.committedOffset;
    }

    public void setCommittedOffset(Offset committedOffset) {
        this.committedOffset = committedOffset;
    }

    public long getCommittedSequence() {
        return this.committedOffset.getSequence();
    }

    public ConcurrentLinkedQueue<RecordKeyImpl> getQueue() {
        return this.queue;
    }

    public long getLastUnReadySeq() {
        return this.lastUnReadySeq;
    }

    public void setLastUnReadySeq(long lastUnReadySeq) {
        this.lastUnReadySeq = lastUnReadySeq;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public void setLastCheckTime(long lastCheckTime) {
        this.lastCheckTime = lastCheckTime;
    }

    public AtomicLong getWarningTimes() {
        return this.warningTimes;
    }

    public Object getCheckLock() {
        return this.checkLock;
    }
}

