/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.models;

import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.ShardEntry;
import com.aliyun.datahub.client.model.ShardState;
import com.aliyun.datahub.clientlibrary.models.Assignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShardMeta {
    private List<String> shardIds = new ArrayList<String>();
    private Set<String> activeShardIds = new HashSet<String>();
    private Map<String, String> addressMap = new HashMap<String, String>();
    private Set<String> addressSet = new HashSet<String>();
    private Map<String, ShardState> stateMap = new HashMap<String, ShardState>();
    private boolean finished = true;
    private final Assignment activeAssignment;
    private String protocol;
    private long intervalMs;
    private long timestamp;

    public ShardMeta(ListShardResult listShardResult) {
        for (ShardEntry shardEntry : listShardResult.getShards()) {
            if (ShardState.ACTIVE.equals((Object)shardEntry.getState())) {
                this.activeShardIds.add(shardEntry.getShardId());
            } else if (ShardState.OPENING.equals((Object)shardEntry.getState()) || ShardState.CLOSING.equals((Object)shardEntry.getState())) {
                this.finished = false;
            }
            this.shardIds.add(shardEntry.getShardId());
            this.addressMap.put(shardEntry.getShardId(), shardEntry.getAddress());
            this.stateMap.put(shardEntry.getShardId(), shardEntry.getState());
            this.addressSet.add(shardEntry.getAddress());
        }
        this.timestamp = System.currentTimeMillis();
        this.activeAssignment = new Assignment(this.activeShardIds, this.timestamp);
        this.protocol = listShardResult.getProtocol();
        this.intervalMs = listShardResult.getIntervalMs();
    }

    public Set<String> getActiveShardIds() {
        return this.activeShardIds;
    }

    public Map<String, String> getAddressMap() {
        return this.addressMap;
    }

    public Set<String> getAddressSet() {
        return this.addressSet;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Map<String, ShardState> getStateMap() {
        return this.stateMap;
    }

    public Assignment getActiveAssignment() {
        return this.activeAssignment;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public long getIntervalMs() {
        return this.intervalMs;
    }

    public List<String> getShardIds() {
        return this.shardIds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

