/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.producer;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.ShardSealedException;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.clientlibrary.common.ClientHelper;
import com.aliyun.datahub.clientlibrary.config.ProducerConfig;
import com.aliyun.datahub.clientlibrary.producer.ShardWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ShardGroupWriter.class);
    private ProducerConfig config;
    private String projectName;
    private String topicName;
    private final ClientHelper clientHelper;
    private final ShardWriterPicker shardWriterPicker = new ShardWriterPicker();
    private final Map<String, ShardWriter> shardWriterMap = new HashMap<String, ShardWriter>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();

    ShardGroupWriter(String projectName, String topicName, ProducerConfig config, ClientHelper clientHelper) {
        this.config = config;
        this.projectName = projectName;
        this.topicName = topicName;
        this.clientHelper = clientHelper;
    }

    Set<String> getShards() {
        try {
            this.rLock.lock();
            Set<String> set = this.shardWriterMap.keySet();
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createShardWriter(List<String> shardIds) {
        this.checkNotClosed();
        try {
            this.wLock.lock();
            for (String shardId : shardIds) {
                if (this.shardWriterMap.containsKey(shardId)) continue;
                ShardWriter shardWriter = new ShardWriter(this.projectName, this.topicName, shardId, this.config, this.clientHelper);
                this.shardWriterMap.put(shardId, shardWriter);
                this.shardWriterPicker.addShardWriter(shardWriter);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeShardWriter(List<String> shardIds) {
        this.checkNotClosed();
        try {
            this.wLock.lock();
            for (String shardId : shardIds) {
                ShardWriter shardWriter = this.shardWriterMap.get(shardId);
                if (shardWriter == null) continue;
                this.shardWriterMap.remove(shardId);
                this.shardWriterPicker.removeShardWriter(shardWriter);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String write(List<RecordEntry> records, String shardId) {
        ShardWriter shardWriter;
        this.checkNotClosed();
        try {
            this.rLock.lock();
            shardWriter = shardId != null ? this.shardWriterMap.get(shardId) : this.shardWriterPicker.pick();
        }
        finally {
            this.rLock.unlock();
        }
        if (shardWriter == null) {
            throw new DatahubClientException("No active writer");
        }
        try {
            shardWriter.write(records);
            return shardWriter.getShardId();
        }
        catch (ShardSealedException e) {
            try {
                this.wLock.lock();
                this.shardWriterPicker.removeShardWriter(shardWriter);
                throw e;
            }
            catch (Throwable throwable) {
                this.wLock.unlock();
                throw throwable;
            }
        }
    }

    void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.wLock.lock();
                for (ShardWriter shardWriter : this.shardWriterMap.values()) {
                    this.shardWriterPicker.removeShardWriter(shardWriter);
                }
                this.shardWriterMap.clear();
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    private void checkNotClosed() {
        if (this.closed.get()) {
            LOG.error("This shard group writer has already been closed, Project: {}, Topic: {}", (Object)this.projectName, (Object)this.topicName);
            throw new DatahubClientException("This shard group writer has already been closed");
        }
    }

    private class ShardWriterPicker {
        private final AtomicInteger index = new AtomicInteger(Math.abs(new Random().nextInt()));
        private final List<ShardWriter> shardWriterList = new ArrayList<ShardWriter>();

        private ShardWriterPicker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ShardWriter pick() {
            if (this.shardWriterList.isEmpty()) {
                return null;
            }
            int curIndex = this.index.incrementAndGet();
            if (curIndex > this.shardWriterList.size() << 10) {
                AtomicInteger atomicInteger = this.index;
                synchronized (atomicInteger) {
                    if (curIndex > this.shardWriterList.size() << 10) {
                        this.index.addAndGet(-(this.shardWriterList.size() << 10));
                    }
                }
            }
            return this.shardWriterList.get(curIndex % this.shardWriterList.size());
        }

        void addShardWriter(ShardWriter shardWriter) {
            this.shardWriterList.add(shardWriter);
        }

        void removeShardWriter(ShardWriter shardWriter) {
            this.shardWriterList.remove(shardWriter);
        }

        int getSize() {
            return this.shardWriterList.size();
        }
    }
}

