/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.producer;

import com.aliyun.datahub.client.exception.ExpiredAccessTokenException;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.clientlibrary.common.ClientHelper;
import com.aliyun.datahub.clientlibrary.config.ProducerConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ShardWriter.class);
    private ProducerConfig config;
    private ClientHelper clientHelper;
    private String projectName;
    private String topicName;
    private String shardId;

    ShardWriter(String projectName, String topicName, String shardId, ProducerConfig config, ClientHelper clientHelper) {
        this.config = config;
        this.clientHelper = clientHelper;
        this.projectName = projectName;
        this.topicName = topicName;
        this.shardId = shardId;
    }

    void write(List<RecordEntry> records) {
        try {
            this.clientHelper.getDataClient().putRecordsByShard(this.shardId, records);
        }
        catch (ExpiredAccessTokenException e) {
            LOG.info("Refresh token, Project: {}, Topic: {}, Shard: {}", new Object[]{this.projectName, this.topicName, this.shardId, e});
            throw e;
        }
    }

    String getShardId() {
        return this.shardId;
    }
}

