/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;

public class TypeInfoParser {
    private ArrayList<String> tokens = new ArrayList();
    private String typeInfoName;
    private int index = 0;

    TypeInfoParser(String name) {
        this.typeInfoName = name.toUpperCase();
        this.tokenize(this.typeInfoName);
    }

    private boolean isTypeInfoChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.';
    }

    private void tokenize(String name) {
        int begin = 0;
        for (int end = 1; end <= name.length(); ++end) {
            if (end != name.length() && this.isTypeInfoChar(name.charAt(end)) && this.isTypeInfoChar(name.charAt(end - 1))) continue;
            String token = name.substring(begin, end).trim();
            if (!token.isEmpty()) {
                this.tokens.add(token);
            }
            begin = end;
        }
    }

    private TypeInfo parseTypeInfo() {
        TypeInfo type = this.parseTypeInfoInternal();
        if (this.index != this.tokens.size()) {
            throw new IllegalArgumentException("Parse type info failed, pls check: " + this.typeInfoName);
        }
        return type;
    }

    private TypeInfo parseTypeInfoInternal() {
        OdpsType typeCategory = OdpsType.valueOf(this.peek());
        switch (typeCategory) {
            case ARRAY: {
                return this.parseArrayTypeInfo();
            }
            case MAP: {
                return this.parseMapTypeInfo();
            }
            case STRUCT: {
                return this.parseStructTypeInfo();
            }
            case CHAR: {
                return this.parseCharTypeInfo();
            }
            case VARCHAR: {
                return this.parseVarcharTypeInfo();
            }
            case DECIMAL: {
                return this.parseComplexDecimalTypeInfo();
            }
        }
        return TypeInfoFactory.getPrimitiveTypeInfo(typeCategory);
    }

    private String peek() {
        if (this.index >= this.tokens.size()) {
            throw new IllegalArgumentException("Parse type info failed, pls check: " + this.typeInfoName);
        }
        return this.tokens.get(this.index++);
    }

    private int getPosition(int tokenIndex) {
        int pos = 0;
        for (int i = 0; i < tokenIndex; ++i) {
            pos += this.tokens.get(i).length();
        }
        return pos;
    }

    private void expect(String expected) {
        if (!this.peek().equals(expected)) {
            throw new IllegalArgumentException("Error parse type info: " + this.typeInfoName + ", expect '" + expected + "' in position: " + this.getPosition(this.index - 1));
        }
    }

    private int getInteger() {
        try {
            return Integer.parseInt(this.peek());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error parse type info: " + this.typeInfoName + ", expect integer in position: " + this.getPosition(this.index - 1), e);
        }
    }

    private int getCharParam() {
        this.expect("(");
        int length = this.getInteger();
        this.expect(")");
        return length;
    }

    private int[] getDecimalParams() {
        if (this.index >= this.tokens.size() || !this.tokens.get(this.index).equals("(")) {
            return null;
        }
        this.expect("(");
        int precision = this.getInteger();
        this.expect(",");
        int scale = this.getInteger();
        this.expect(")");
        return new int[]{precision, scale};
    }

    private TypeInfo parseArrayTypeInfo() {
        this.expect("<");
        TypeInfo elementTypeInfo = this.parseTypeInfoInternal();
        this.expect(">");
        return TypeInfoFactory.getArrayTypeInfo(elementTypeInfo);
    }

    private TypeInfo parseMapTypeInfo() {
        this.expect("<");
        TypeInfo keyTypeInfo = this.parseTypeInfoInternal();
        this.expect(",");
        TypeInfo valueTypeInfo = this.parseTypeInfoInternal();
        this.expect(">");
        return TypeInfoFactory.getMapTypeInfo(keyTypeInfo, valueTypeInfo);
    }

    private TypeInfo parseStructTypeInfo() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        boolean first = true;
        while (true) {
            if (first) {
                this.expect("<");
                first = false;
            } else {
                String delimiter = this.peek();
                if (delimiter.equals(">")) break;
                --this.index;
                this.expect(",");
            }
            names.add(this.peek());
            this.expect(":");
            typeInfos.add(this.parseTypeInfoInternal());
        }
        return TypeInfoFactory.getStructTypeInfo(names, typeInfos);
    }

    private TypeInfo parseVarcharTypeInfo() {
        return TypeInfoFactory.getVarcharTypeInfo(this.getCharParam());
    }

    private TypeInfo parseCharTypeInfo() {
        return TypeInfoFactory.getCharTypeInfo(this.getCharParam());
    }

    private TypeInfo parseComplexDecimalTypeInfo() {
        int[] params = this.getDecimalParams();
        if (params == null) {
            return TypeInfoFactory.DECIMAL;
        }
        return TypeInfoFactory.getDecimalTypeInfo(params[0], params[1]);
    }

    public static TypeInfo getTypeInfoFromTypeString(String name) {
        return new TypeInfoParser(name).parseTypeInfo();
    }
}

