/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.pipeline;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.RecordComparator;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Pipeline {
    private static final String PIPELINE_LIST = "odps.pipeline.list";
    private static final String PIPELINE = "odps.pipeline.";
    private static final String OUTPUT_KEY_SCHEMA = ".output.key.schema";
    private static final String OUTPUT_VALUE_SCHEMA = ".output.value.schema";
    private static final String OUTPUT_KEY_SORT_COLUMNS = ".output.key.sort.columns";
    private static final String OUTPUT_KEY_SORT_ORDER = ".output.key.sort.order";
    private static final String OUTPUT_GROUP_COLUMNS = ".output.group.columns";
    private static final String PARTITION_COLUMNS = ".partition.columns";
    private static final String PARTITION_CLASS = ".partition.class";
    private static final String OUTPUT_KEY_COMPARATOR_CLASS = ".output.key.comparator.class";
    private static final String OUTPUT_KEY_GROUPING_COMPARATOR_CLASS = ".output.key.grouping.comparator.class";
    private List<TransformNode> nodes = new ArrayList<TransformNode>();

    public Pipeline(List<TransformNode> nodes) {
        this.nodes = nodes;
    }

    public TransformNode getNode(int index) {
        if (index >= 0 && index < this.nodes.size()) {
            return this.nodes.get(index);
        }
        return null;
    }

    public TransformNode getFirstNode() {
        return this.getNode(0);
    }

    public TransformNode getLastNode() {
        return this.getNode(this.getNodeNum() - 1);
    }

    public int getNodeNum() {
        return this.nodes.size();
    }

    public List<TransformNode> getNodes() {
        return this.nodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void toJobConf(JobConf conf, Pipeline pipeline) {
        StringBuilder sb = new StringBuilder();
        List<TransformNode> nodes = pipeline.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            TransformNode node = nodes.get(i);
            sb.append(node.type);
            sb.append(":");
            sb.append(node.getTransformClass().getName());
            if (i != nodes.size() - 1) {
                sb.append(",");
            }
            if (node.getOutputKeySchema() != null) {
                conf.set(PIPELINE + i + OUTPUT_KEY_SCHEMA, SchemaUtils.toString(node.getOutputKeySchema()));
            }
            if (node.getOutputValueSchema() != null) {
                conf.set(PIPELINE + i + OUTPUT_VALUE_SCHEMA, SchemaUtils.toString(node.getOutputValueSchema()));
            }
            if (node.getOutputKeySortColumns() != null) {
                conf.set(PIPELINE + i + OUTPUT_KEY_SORT_COLUMNS, StringUtils.join((Object[])node.getOutputKeySortColumns(), (String)","));
            }
            conf.set(PIPELINE + i + OUTPUT_KEY_SORT_ORDER, StringUtils.join((Object[])node.getOutputKeySortOrder(), (String)","));
            if (node.getPartitionColumns() != null) {
                conf.set(PIPELINE + i + PARTITION_COLUMNS, StringUtils.join((Object[])node.getPartitionColumns(), (String)","));
            }
            if (node.getPartitionerClass() != null) {
                conf.set(PIPELINE + i + PARTITION_CLASS, node.getPartitionerClass().getName());
            }
            if (node.getOutputGroupingColumns() != null) {
                conf.set(PIPELINE + i + OUTPUT_GROUP_COLUMNS, StringUtils.join((Object[])node.getOutputGroupingColumns(), (String)","));
            }
            if (node.getOutputKeyComparatorClass() != null) {
                conf.set(PIPELINE + i + OUTPUT_KEY_COMPARATOR_CLASS, node.getOutputKeyComparatorClass().getName());
            }
            if (node.getOutputKeyGroupingComparatorClass() != null) {
                conf.set(PIPELINE + i + OUTPUT_KEY_GROUPING_COMPARATOR_CLASS, node.getOutputKeyGroupingComparatorClass().getName());
            }
            if (node.getNumTasks() >= 0) {
                if (i == 0) {
                    conf.setInt("odps.stage.mapper.num", node.getNumTasks());
                } else {
                    conf.setInt("odps.stage.reducer." + i + ".num", node.getNumTasks());
                }
            }
            if (node.getMemoryForTask() >= 0) {
                if (i == 0) {
                    conf.setInt("odps.stage.mapper.mem", node.getMemoryForTask());
                } else {
                    conf.setInt("odps.stage.reducer." + i + ".mem", node.getMemoryForTask());
                }
            }
            if (node.getMemoryForJVM() < 0) continue;
            if (i == 0) {
                conf.setInt("odps.stage.mapper.jvm.mem", node.getMemoryForJVM());
                continue;
            }
            conf.setInt("odps.stage.reducer." + i + ".jvm.mem", node.getMemoryForJVM());
        }
        conf.set(PIPELINE_LIST, sb.toString());
    }

    public static Pipeline fromJobConf(JobConf conf) {
        String pipes = conf.get(PIPELINE_LIST);
        if (pipes == null) {
            return null;
        }
        Builder builder = Pipeline.builder();
        String[] pipelist = pipes.split(",");
        for (int i = 0; i < pipelist.length; ++i) {
            String keyGrpCmpClass;
            String keyCmpClass;
            String groupCols;
            String partClass;
            String partCols;
            String joined;
            String sortCols;
            String valueSchema;
            block35: {
                String pipe = pipelist[i];
                String[] parts = pipe.split(":");
                try {
                    Class cls = conf.getClassByName(parts[1]);
                    if (cls != null) {
                        if (parts[0].equals("map")) {
                            if (!Mapper.class.isAssignableFrom(cls)) {
                                throw new RuntimeException(cls + " not Mapper");
                            }
                            builder.addMapper(cls.asSubclass(Mapper.class));
                        } else if (parts[0].equals("reduce")) {
                            if (!Reducer.class.isAssignableFrom(cls)) {
                                throw new RuntimeException(cls + " not Reducer");
                            }
                            builder.addReducer(cls.asSubclass(Reducer.class));
                        }
                        break block35;
                    }
                    throw new RuntimeException("Class " + parts[1] + " not found");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class " + parts[1] + " not found");
                }
            }
            String keySchema = conf.get(PIPELINE + i + OUTPUT_KEY_SCHEMA);
            if (keySchema != null) {
                builder.setOutputKeySchema(SchemaUtils.fromString(keySchema));
            }
            if ((valueSchema = conf.get(PIPELINE + i + OUTPUT_VALUE_SCHEMA)) != null) {
                builder.setOutputValueSchema(SchemaUtils.fromString(valueSchema));
            }
            if ((sortCols = conf.get(PIPELINE + i + OUTPUT_KEY_SORT_COLUMNS)) != null) {
                builder.setOutputKeySortColumns(sortCols.split(","));
            }
            if ((joined = conf.get(PIPELINE + i + OUTPUT_KEY_SORT_ORDER)) != null && !joined.isEmpty()) {
                String[] orders = joined.split(",");
                JobConf.SortOrder[] order = new JobConf.SortOrder[orders.length];
                for (int j = 0; j < order.length; ++j) {
                    order[j] = JobConf.SortOrder.valueOf(orders[j]);
                }
                builder.setOutputKeySortOrder(order);
            }
            if ((partCols = conf.get(PIPELINE + i + PARTITION_COLUMNS)) != null && !partCols.isEmpty()) {
                builder.setPartitionColumns(partCols.split(","));
            }
            if ((partClass = conf.get(PIPELINE + i + PARTITION_CLASS)) != null && !partClass.isEmpty()) {
                try {
                    Class cls = conf.getClassByName(partClass);
                    if (cls != null) {
                        if (!Partitioner.class.isAssignableFrom(cls)) {
                            throw new RuntimeException(cls + " not Partitioner");
                        }
                    } else {
                        throw new RuntimeException("Class " + partClass + " not found");
                    }
                    builder.setPartitionerClass(cls.asSubclass(Partitioner.class));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class " + partClass + " not found");
                }
            }
            if ((groupCols = conf.get(PIPELINE + i + OUTPUT_GROUP_COLUMNS)) != null && !groupCols.isEmpty()) {
                builder.setOutputGroupingColumns(groupCols.split(","));
            }
            if ((keyCmpClass = conf.get(PIPELINE + i + OUTPUT_KEY_COMPARATOR_CLASS)) != null && !keyCmpClass.isEmpty()) {
                try {
                    Class cls = conf.getClassByName(keyCmpClass);
                    if (cls != null) {
                        if (!RecordComparator.class.isAssignableFrom(cls)) {
                            throw new RuntimeException(cls + " not RecordComparator");
                        }
                    } else {
                        throw new RuntimeException("Class " + keyCmpClass + " not found");
                    }
                    builder.setOutputKeyComparatorClass(cls.asSubclass(RecordComparator.class));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class " + keyCmpClass + " not found");
                }
            }
            if ((keyGrpCmpClass = conf.get(PIPELINE + i + OUTPUT_KEY_GROUPING_COMPARATOR_CLASS)) != null && !keyGrpCmpClass.isEmpty()) {
                try {
                    Class cls = conf.getClassByName(keyGrpCmpClass);
                    if (cls != null) {
                        if (!RecordComparator.class.isAssignableFrom(cls)) {
                            throw new RuntimeException(cls + " not RecordComparator");
                        }
                    } else {
                        throw new RuntimeException("Class " + keyGrpCmpClass + " not found");
                    }
                    builder.setOutputKeyGroupingComparatorClass(cls.asSubclass(RecordComparator.class));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class " + keyGrpCmpClass + " not found");
                }
            }
            int numTasks = 1;
            numTasks = i == 0 ? conf.getInt("odps.stage.mapper.num", 1) : conf.getInt("odps.stage.reducer." + i + ".num", conf.getInt("odps.stage.reducer.num", 1));
            builder.setNumTasks(numTasks);
        }
        return builder.createPipeline();
    }

    public static class Builder {
        private List<TransformNode> nodes = new ArrayList<TransformNode>();
        private TransformNode lastNode;

        public Builder addMapper(Class<? extends Mapper> mapper) {
            MapNode map = new MapNode(mapper);
            this.nodes.add(map);
            this.lastNode = map;
            return this;
        }

        public Builder addMapper(Class<? extends Mapper> mapper, Column[] keySchema, Column[] valueSchema, String[] sortCols, JobConf.SortOrder[] order, String[] partCols, Class<? extends Partitioner> theClass, String[] groupCols) {
            this.addMapper(mapper).setOutputKeySchema(keySchema).setOutputValueSchema(valueSchema).setOutputKeySortColumns(sortCols).setOutputKeySortOrder(order).setPartitionColumns(partCols).setPartitionerClass(theClass).setOutputGroupingColumns(groupCols);
            return this;
        }

        public Builder addReducer(Class<? extends Reducer> reducer) {
            ReduceNode reduce = new ReduceNode(reducer);
            reduce.setPreviousNode(this.lastNode);
            if (this.lastNode != null) {
                this.lastNode.setNextNode(reduce);
            }
            this.nodes.add(reduce);
            this.lastNode = reduce;
            return this;
        }

        public Builder addReducer(Class<? extends Reducer> reducer, Column[] keySchema, Column[] valueSchema, String[] sortCols, JobConf.SortOrder[] order, String[] partCols, Class<? extends Partitioner> theClass, String[] groupCols) {
            this.addReducer(reducer).setOutputKeySchema(keySchema).setOutputValueSchema(valueSchema).setOutputKeySortColumns(sortCols).setOutputKeySortOrder(order).setPartitionColumns(partCols).setPartitionerClass(theClass).setOutputGroupingColumns(groupCols);
            return this;
        }

        public Builder setOutputKeySchema(Column[] keySchema) {
            if (this.lastNode != null) {
                this.lastNode.setOutputKeySchema(keySchema);
            }
            return this;
        }

        public Builder setOutputValueSchema(Column[] valueSchema) {
            if (this.lastNode != null) {
                this.lastNode.setOutputValueSchema(valueSchema);
            }
            return this;
        }

        public Builder setOutputKeySortColumns(String[] sortCols) {
            if (this.lastNode != null) {
                this.lastNode.setOutputKeySortColumns(sortCols);
            }
            return this;
        }

        public Builder setOutputKeySortOrder(JobConf.SortOrder[] order) {
            if (this.lastNode != null) {
                this.lastNode.setOutputKeySortOrder(order);
            }
            return this;
        }

        public Builder setPartitionColumns(String[] partCols) {
            if (this.lastNode != null) {
                this.lastNode.setPartitionColumns(partCols);
            }
            return this;
        }

        public Builder setPartitionerClass(Class<? extends Partitioner> theClass) {
            if (this.lastNode != null) {
                this.lastNode.setPartitionerClass(theClass);
            }
            return this;
        }

        public Builder setNumTasks(int n) {
            if (this.lastNode != null) {
                this.lastNode.setNumTasks(n);
            }
            return this;
        }

        public Builder setMemoryForTask(int mem) {
            if (this.lastNode != null) {
                this.lastNode.setMemoryForTask(mem);
            }
            return this;
        }

        public Builder setMemoryForJVM(int mem) {
            if (this.lastNode != null) {
                this.lastNode.setMemoryForJVM(mem);
            }
            return this;
        }

        public Builder setOutputGroupingColumns(String[] cols) {
            if (this.lastNode != null) {
                this.lastNode.setOutputGroupingColumns(cols);
            }
            return this;
        }

        public Builder setOutputKeyComparatorClass(Class<? extends RecordComparator> theClass) {
            if (this.lastNode != null) {
                this.lastNode.setOutputKeyComparatorClass(theClass);
            }
            return this;
        }

        public Builder setOutputKeyGroupingComparatorClass(Class<? extends RecordComparator> theClass) {
            if (this.lastNode != null) {
                this.lastNode.setOutputKeyGroupingComparatorClass(theClass);
            }
            return this;
        }

        public Pipeline createPipeline() {
            return new Pipeline(this.nodes);
        }
    }

    public static class ReduceNode
    extends TransformNode {
        private Class<? extends Reducer> reducer;

        public ReduceNode(Class<? extends Reducer> reducer) {
            this.reducer = reducer;
            this.type = "reduce";
        }

        @Override
        public Class<? extends Reducer> getTransformClass() {
            return this.reducer;
        }
    }

    public static class MapNode
    extends TransformNode {
        private Class<? extends Mapper> mapper;

        public MapNode(Class<? extends Mapper> mapper) {
            this.mapper = mapper;
            this.type = "map";
        }

        @Override
        public Class<? extends Mapper> getTransformClass() {
            return this.mapper;
        }
    }

    public static abstract class TransformNode {
        Column[] keySchema;
        Column[] valueSchema;
        String[] sortCols;
        JobConf.SortOrder[] order;
        String[] partCols;
        Class<? extends Partitioner> partitionerClass;
        Class<? extends RecordComparator> keyComparatorClass;
        Class<? extends RecordComparator> keyGroupingComparatorClass;
        String[] groupCols;
        String type;
        TransformNode prevNode;
        TransformNode nextNode;
        int taskNum = -1;
        int taskMemoryMB = -1;
        int jvmMemoryMB = -1;

        public String getType() {
            return this.type;
        }

        public void setPreviousNode(TransformNode prev) {
            this.prevNode = prev;
        }

        public TransformNode getPreviousNode() {
            return this.prevNode;
        }

        public void setNextNode(TransformNode next) {
            this.nextNode = next;
        }

        public TransformNode getNextNode() {
            return this.nextNode;
        }

        public Column[] getInputKeySchema() {
            if (this.prevNode != null) {
                return this.prevNode.getOutputKeySchema();
            }
            return null;
        }

        public Column[] getInputValueSchema() {
            if (this.prevNode != null) {
                return this.prevNode.getOutputValueSchema();
            }
            return null;
        }

        public String[] getInputGroupingColumns() {
            if (this.prevNode != null) {
                return this.prevNode.getOutputGroupingColumns();
            }
            return null;
        }

        public void setOutputKeySchema(Column[] keySchema) {
            this.keySchema = keySchema;
        }

        public Column[] getOutputKeySchema() {
            return this.keySchema;
        }

        public void setOutputValueSchema(Column[] valueSchema) {
            this.valueSchema = valueSchema;
        }

        public Column[] getOutputValueSchema() {
            return this.valueSchema;
        }

        public void setOutputKeySortOrder(JobConf.SortOrder[] order) {
            this.order = order;
        }

        public JobConf.SortOrder[] getOutputKeySortOrder() {
            JobConf.SortOrder[] order = this.order;
            if ((order == null || order.length == 0) && this.getOutputKeySchema() != null) {
                order = new JobConf.SortOrder[this.getOutputKeySchema().length];
                Arrays.fill((Object[])order, (Object)JobConf.SortOrder.ASC);
            } else if (order == null) {
                order = new JobConf.SortOrder[]{};
            }
            return order;
        }

        public void setOutputKeySortColumns(String[] sortCols) {
            this.sortCols = sortCols;
        }

        public String[] getOutputKeySortColumns() {
            if (this.sortCols != null) {
                return this.sortCols;
            }
            if (this.keySchema != null) {
                return SchemaUtils.getNames(this.getOutputKeySchema());
            }
            return null;
        }

        public void setPartitionColumns(String[] partCols) {
            this.partCols = partCols;
        }

        public String[] getPartitionColumns() {
            if (this.partCols != null) {
                return this.partCols;
            }
            if (this.keySchema != null) {
                return SchemaUtils.getNames(this.getOutputKeySchema());
            }
            return null;
        }

        public void setPartitionerClass(Class<? extends Partitioner> theClass) {
            this.partitionerClass = theClass;
        }

        public Class<? extends Partitioner> getPartitionerClass() {
            return this.partitionerClass;
        }

        public void setOutputGroupingColumns(String[] groupCols) {
            this.groupCols = groupCols;
        }

        public String[] getOutputGroupingColumns() {
            if (this.groupCols != null) {
                return this.groupCols;
            }
            if (this.keySchema != null) {
                return SchemaUtils.getNames(this.getOutputKeySchema());
            }
            return null;
        }

        public Class<? extends RecordComparator> getInputKeyComparatorClass() {
            if (this.getPreviousNode() != null) {
                return this.getPreviousNode().getOutputKeyComparatorClass();
            }
            return null;
        }

        public Class<? extends RecordComparator> getInputKeyGroupingComparatorClass() {
            if (this.getPreviousNode() != null) {
                return this.getPreviousNode().getOutputKeyGroupingComparatorClass();
            }
            return null;
        }

        public Class<? extends RecordComparator> getOutputKeyComparatorClass() {
            return this.keyComparatorClass;
        }

        public void setOutputKeyComparatorClass(Class<? extends RecordComparator> theClass) {
            this.keyComparatorClass = theClass;
        }

        public Class<? extends RecordComparator> getOutputKeyGroupingComparatorClass() {
            return this.keyGroupingComparatorClass;
        }

        public void setOutputKeyGroupingComparatorClass(Class<? extends RecordComparator> theClass) {
            this.keyGroupingComparatorClass = theClass;
        }

        public abstract Class getTransformClass();

        public void setNumTasks(int n) {
            this.taskNum = n;
        }

        public int getNumTasks() {
            return this.taskNum;
        }

        public void setMemoryForTask(int mem) {
            this.taskMemoryMB = mem;
        }

        public int getMemoryForTask() {
            return this.taskMemoryMB;
        }

        public void setMemoryForJVM(int mem) {
            this.jvmMemoryMB = mem;
        }

        public int getMemoryForJVM() {
            return this.jvmMemoryMB;
        }
    }
}

