/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.auth.handler.accesskey;

import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.aliyun.openservices.iot.api.auth.handler.accesskey.RamAuthRequest;
import com.aliyun.openservices.iot.api.auth.handler.accesskey.RamAuthResponse;
import com.aliyun.openservices.iot.api.exception.IotClientException;
import com.aliyun.openservices.iot.api.util.StringUtil;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class AccessKeyAuthHandler
implements AuthHandler {
    private static final String PARAM_IOT_TOKEN = "param-token";
    private static final String PARAM_IOT_ID = "param-iot-id";
    private String iotId;
    private String token;
    private long validDuration;
    private long fetchTime;
    private IAcsClient client;

    public AccessKeyAuthHandler(Map<String, String> params) {
        String accessKey = params.get("accessKey");
        String accessSecret = params.get("accessSecret");
        String stsToken = params.get("stsToken");
        String regionId = params.get("regionId");
        try {
            DefaultProfile.addEndpoint((String)regionId, (String)regionId, (String)"iot", (String)params.getOrDefault("aliyuncs-host", "iot." + regionId + ".aliyuncs.com"));
        }
        catch (ClientException e) {
            throw new IotClientException(e);
        }
        DefaultProfile profile = null;
        profile = StringUtil.isNotEmpty(stsToken) ? DefaultProfile.getProfile((String)regionId, (String)accessKey, (String)accessSecret, (String)stsToken) : DefaultProfile.getProfile((String)regionId, (String)accessKey, (String)accessSecret);
        this.client = new DefaultAcsClient((IClientProfile)profile);
    }

    @Override
    public Map<String, String> getAuthParams() {
        if (System.currentTimeMillis() - this.fetchTime > this.validDuration) {
            this.updateToken();
        }
        HashMap authParams = Maps.newHashMap();
        authParams.put(PARAM_IOT_TOKEN, this.token);
        authParams.put(PARAM_IOT_ID, this.iotId);
        authParams.put("name", "aliyunak");
        return authParams;
    }

    private void updateToken() {
        RamAuthRequest ramAuthRequest = new RamAuthRequest();
        try {
            RamAuthResponse ramAuthResponse = (RamAuthResponse)this.client.getAcsResponse((AcsRequest)ramAuthRequest);
            this.fetchTime = System.currentTimeMillis();
            this.validDuration = ramAuthResponse.getValidDuration();
            this.iotId = ramAuthResponse.getIotId();
            this.token = ramAuthResponse.getIotToken();
        }
        catch (ClientException e) {
            throw new IotClientException(e);
        }
    }
}

