/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.auth;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.BceV1Signer;
import com.baidubce.auth.SignOptions;
import com.baidubce.internal.BaseRequest;
import com.baidubce.internal.InternalRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature {
    private static final Logger LOGGER = LoggerFactory.getLogger(Signature.class);
    private static final String AUTH_PREFIX = "bce-auth-v1";

    public boolean verify(BaseRequest baseRequest, BceCredentials credentials) {
        return this.verify(baseRequest, credentials, "Authorization");
    }

    public boolean verify(BaseRequest baseRequest, BceCredentials credentials, String authHeader) {
        Date date;
        if (baseRequest == null || credentials == null || authHeader == null) {
            return false;
        }
        Map<String, String> headers = baseRequest.getHeaders();
        if (headers == null || headers.get("Host") == null && headers.get("Host".toLowerCase()) == null) {
            return false;
        }
        String authString = headers.get(authHeader);
        if (authString == null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (!header.getKey().equalsIgnoreCase(authHeader)) continue;
                authString = header.getValue();
                break;
            }
        }
        if (authString == null) {
            return false;
        }
        String[] parts = authString.split("/", 6);
        if (parts.length != 6) {
            return false;
        }
        if (!parts[0].equals(AUTH_PREFIX)) {
            return false;
        }
        String accessKey = parts[1];
        if (!accessKey.equals(credentials.getAccessKeyId())) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = format.parse(parts[2]);
        }
        catch (ParseException e) {
            LOGGER.error("parse timestamp error.");
            return false;
        }
        SignOptions options = new SignOptions();
        options.setTimestamp(date);
        options.setExpirationInSeconds(Integer.parseInt(parts[3]));
        if (StringUtils.isEmpty((CharSequence)parts[4])) {
            options = SignOptions.DEFAULT;
            options.setTimestamp(date);
        } else {
            String[] signedHeaders = parts[4].split(";");
            options.setHeadersToSign(new TreeSet<String>(Arrays.asList(signedHeaders)));
        }
        InternalRequest request = BaseRequest.toInternalRequest(baseRequest);
        BceV1Signer signer = new BceV1Signer();
        request.setSignOptions(options);
        signer.sign(request, credentials);
        String verifiedAuth = request.getHeaders().get("Authorization");
        return authString.split("/")[5].equals(verifiedAuth.split("/")[5]);
    }
}

