/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.services.bos.model.GenericBucketRequest;
import com.google.common.base.Preconditions;

public abstract class GenericObjectRequest
extends GenericBucketRequest {
    private static final int MIN_OBJECT_KEY_LENGTH = 1;
    private static final int MAX_OBJECT_KEY_LENGTH = 1024;
    private String key;

    public GenericObjectRequest() {
    }

    public GenericObjectRequest(String bucketName, String key) {
        super(bucketName);
        this.setKey(key);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null.");
        if (key.length() < 1) {
            throw new IllegalArgumentException("Invalid objectKey:" + key + ". objectKey should not be less than " + 1 + ".");
        }
        if (key.length() > 1024) {
            throw new IllegalArgumentException("Invalid objectKey:" + key + ". objectKey should not be greater than " + 1024 + ".");
        }
        if (key.startsWith("/")) {
            boolean isDelimiters = true;
            for (int i = 1; i < key.length(); ++i) {
                if (key.charAt(i) == '/') continue;
                isDelimiters = false;
                break;
            }
            if (isDelimiters) {
                throw new IllegalArgumentException("Invalid objectKey:" + key + ". objectKey should not be delimiter.");
            }
        }
        this.key = key;
    }

    public abstract GenericObjectRequest withKey(String var1);
}

