/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.product;

import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdmp.model.device.DeviceType;
import com.baidubce.services.iotdmp.model.device.ResourceType;
import com.baidubce.services.iotdmp.model.product.ProductAccessType;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateProductInfoRequest
extends GenericAccountRequest {
    @NonNull
    private String productName;
    private String productKey;
    private String description;
    @NonNull
    private DeviceType deviceType;
    @NonNull
    private List<String> accessType;
    private List<ResourceType> extensions;
    private String productCategory;

    public CreateProductInfoRequest(String productName, DeviceType deviceType, List<ProductAccessType> accessType) {
        this.productName = productName;
        this.deviceType = deviceType;
        this.accessType = this.convertAlias(accessType);
        this.productCategory = "\u7528\u6237\u81ea\u5b9a\u4e49";
    }

    public CreateProductInfoRequest(String productName, DeviceType deviceType, String productCategory, List<ProductAccessType> accessType) {
        this.productName = productName;
        this.deviceType = deviceType;
        this.accessType = this.convertAlias(accessType);
        this.productCategory = productCategory;
    }

    public CreateProductInfoRequest(String productName, String productKey, String description, DeviceType deviceType, String productCategory, List<ProductAccessType> accessType, List<ResourceType> extensions) {
        this.productName = productName;
        this.productKey = productKey;
        this.description = description;
        this.deviceType = deviceType;
        this.accessType = this.convertAlias(accessType);
        this.extensions = extensions;
        this.productCategory = productCategory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setAccessType(List<ProductAccessType> accessType) {
        this.accessType = this.convertAlias(accessType);
    }

    private List<String> convertAlias(List<ProductAccessType> accessTypes) {
        ArrayList<String> aliasAccessTypes = new ArrayList<String>();
        for (ProductAccessType productAccessType : accessTypes) {
            aliasAccessTypes.add(productAccessType.getAlias());
        }
        return aliasAccessTypes;
    }

    @NonNull
    public String getProductName() {
        return this.productName;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @NonNull
    public List<String> getAccessType() {
        return this.accessType;
    }

    public List<ResourceType> getExtensions() {
        return this.extensions;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public void setProductName(@NonNull String productName) {
        if (productName == null) {
            throw new NullPointerException("productName is marked @NonNull but is null");
        }
        this.productName = productName;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDeviceType(@NonNull DeviceType deviceType) {
        if (deviceType == null) {
            throw new NullPointerException("deviceType is marked @NonNull but is null");
        }
        this.deviceType = deviceType;
    }

    public void setExtensions(List<ResourceType> extensions) {
        this.extensions = extensions;
    }

    public void setProductCategory(String productCategory) {
        this.productCategory = productCategory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateProductInfoRequest)) {
            return false;
        }
        CreateProductInfoRequest other = (CreateProductInfoRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$productKey = this.getProductKey();
        String other$productKey = other.getProductKey();
        if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DeviceType this$deviceType = this.getDeviceType();
        DeviceType other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !((Object)((Object)this$deviceType)).equals((Object)other$deviceType)) {
            return false;
        }
        List<String> this$accessType = this.getAccessType();
        List<String> other$accessType = other.getAccessType();
        if (this$accessType == null ? other$accessType != null : !((Object)this$accessType).equals(other$accessType)) {
            return false;
        }
        List<ResourceType> this$extensions = this.getExtensions();
        List<ResourceType> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        String this$productCategory = this.getProductCategory();
        String other$productCategory = other.getProductCategory();
        return !(this$productCategory == null ? other$productCategory != null : !this$productCategory.equals(other$productCategory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateProductInfoRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $productKey = this.getProductKey();
        result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DeviceType $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : ((Object)((Object)$deviceType)).hashCode());
        List<String> $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : ((Object)$accessType).hashCode());
        List<ResourceType> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        String $productCategory = this.getProductCategory();
        result = result * 59 + ($productCategory == null ? 43 : $productCategory.hashCode());
        return result;
    }

    public String toString() {
        return "CreateProductInfoRequest(productName=" + this.getProductName() + ", productKey=" + this.getProductKey() + ", description=" + this.getDescription() + ", deviceType=" + (Object)((Object)this.getDeviceType()) + ", accessType=" + this.getAccessType() + ", extensions=" + this.getExtensions() + ", productCategory=" + this.getProductCategory() + ")";
    }

    public static class Builder {
        private String productName;
        private String productKey;
        private String description;
        private DeviceType deviceType;
        private String productCategory;
        private List<ProductAccessType> accessType;
        private List<ResourceType> extensions;

        public Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public Builder productKey(String productKey) {
            this.productKey = productKey;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder productCategory(String productCategory) {
            this.productCategory = productCategory;
            return this;
        }

        public Builder accessType(List<ProductAccessType> accessType) {
            this.accessType = accessType;
            return this;
        }

        public Builder extensions(List<ResourceType> extensions) {
            this.extensions = extensions;
            return this;
        }

        public CreateProductInfoRequest build() {
            return new CreateProductInfoRequest(this.productName, this.productKey, this.description, this.deviceType, this.productCategory, this.accessType, this.extensions);
        }
    }
}

