/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.sts;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.services.sts.BceStsJsonResponseHandler;
import com.baidubce.services.sts.model.GetSessionTokenRequest;
import com.baidubce.services.sts.model.GetSessionTokenResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;

public class StsClient
extends AbstractBceClient {
    private static final String GET_SESSION_TOKEN_PATH = "sessionToken";
    private static HttpResponseHandler[] stsHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceStsJsonResponseHandler()};

    public StsClient() {
        this(new BceClientConfiguration());
    }

    public StsClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, stsHandlers);
    }

    public GetSessionTokenResponse getSessionToken() {
        return this.getSessionToken(new GetSessionTokenRequest());
    }

    public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkIsTrue(request.getDurationSeconds() > 0, "the durationSeconds parameter should be greater than zero");
        InternalRequest internalRequest = new InternalRequest(HttpMethodName.POST, HttpUtils.appendUri(this.getEndpoint(), "v1", GET_SESSION_TOKEN_PATH));
        if (request.getDurationSeconds() != null) {
            internalRequest.addParameter("durationSeconds", String.valueOf(request.getDurationSeconds()));
        }
        internalRequest.setCredentials(request.getRequestCredentials());
        if (request.getAcl() != null) {
            byte[] acl;
            try {
                acl = request.getAcl().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Fail to get UTF-8 bytes", e);
            }
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.addHeader("Content-Length", String.valueOf(acl.length));
            internalRequest.setContent(RestartableInputStream.wrap(acl));
        } else {
            internalRequest.addHeader("Content-Length", String.valueOf(0));
        }
        return this.invokeHttpClient(internalRequest, GetSessionTokenResponse.class);
    }
}

