/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tag;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tag.TagClientConfiguration;
import com.baidubce.services.tag.model.CreateTagsRequest;
import com.baidubce.services.tag.model.DeleteTagsRequest;
import com.baidubce.services.tag.model.ListTagResourcesRequest;
import com.baidubce.services.tag.model.ListTagResourcesResponse;
import com.baidubce.services.tag.model.ListTagsRequest;
import com.baidubce.services.tag.model.ListTagsResponse;
import com.baidubce.services.tag.model.Tag;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class TagClient
extends AbstractBceClient {
    private static final String VERSION = "v1/tag";
    private static final HttpResponseHandler[] TAG_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public TagClient() {
        this(new TagClientConfiguration());
    }

    public TagClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, TAG_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public void createTags(List<Tag> tags) {
        this.createTags(new CreateTagsRequest().withTags(tags));
    }

    public void createTags(CreateTagsRequest request) {
        Validate.checkNotNull(request, "request for creating should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "");
        internalRequest.addParameter("create", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagsResponse listTags() {
        return this.listTags(null, null);
    }

    public ListTagsResponse listTags(String tagKey) {
        return this.listTags(tagKey, null);
    }

    public ListTagsResponse listTags(String tagKey, String tagValue) {
        return this.listTags(new ListTagsRequest().withTagKey(tagKey).withTagValue(tagValue));
    }

    public ListTagsResponse listTags(ListTagsRequest request) {
        Validate.checkNotNull(request, "request for listing should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "");
        if (!Strings.isNullOrEmpty((String)request.getTagKey())) {
            internalRequest.addParameter("tagKey", request.getTagKey());
        }
        if (request.getTagValue() != null) {
            internalRequest.addParameter("tagValue", request.getTagValue());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ListTagsResponse.class);
    }

    public void deleteTags(List<Tag> tags) {
        this.deleteTags(new DeleteTagsRequest().withTags(tags));
    }

    public void deleteTags(DeleteTagsRequest request) {
        Validate.checkNotNull(request, "request for deleting should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "");
        internalRequest.addParameter("delete", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResourcesResponse listTagResources() {
        return this.listTagResources(null, null);
    }

    public ListTagResourcesResponse listTagResources(String tagKey, String tagValue) {
        return this.listTagResources(new ListTagResourcesRequest().withTagKey(tagKey).withTagValue(tagValue));
    }

    public ListTagResourcesResponse listTagResources(ListTagResourcesRequest request) {
        Validate.checkNotNull(request, "request for listing should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "/tagResources");
        if (!Strings.isNullOrEmpty((String)request.getTagKey())) {
            internalRequest.addParameter("tagKey", request.getTagKey());
        }
        if (request.getTagValue() != null) {
            internalRequest.addParameter("tagValue", request.getTagValue());
        }
        if (!Strings.isNullOrEmpty((String)request.getResourceType())) {
            internalRequest.addParameter("resourceType", request.getResourceType());
        }
        if (!Strings.isNullOrEmpty((String)request.getRegion())) {
            internalRequest.addParameter("region", request.getRegion());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ListTagResourcesResponse.class);
    }
}

