/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.baomidou.mybatisplus.plugins.parser.ISqlParser;
import com.baomidou.mybatisplus.plugins.parser.SqlInfo;
import com.baomidou.mybatisplus.toolkit.SqlFormatter;
import com.baomidou.mybatisplus.toolkit.StringUtils;

public class SqlUtils {
    private static final SqlFormatter sqlFormatter = new SqlFormatter();
    public static final String SQL_BASE_COUNT = "SELECT COUNT(1) FROM ( %s ) TOTAL";
    public static ISqlParser COUNT_SQL_PARSER = null;

    public static SqlInfo getCountOptimize(ISqlParser sqlParser, String originalSql) {
        if (null == COUNT_SQL_PARSER) {
            COUNT_SQL_PARSER = null != sqlParser ? sqlParser : new JsqlParserCountOptimize();
        }
        return COUNT_SQL_PARSER.optimizeSql(null, originalSql);
    }

    public static String concatOrderBy(String originalSql, Pagination page, boolean orderBy) {
        if (orderBy && StringUtils.isNotEmpty(page.getOrderByField()) && page.isOpenSort()) {
            StringBuilder buildSql = new StringBuilder(originalSql);
            buildSql.append(" ORDER BY ").append(page.getOrderByField());
            buildSql.append(page.isAsc() ? " ASC " : " DESC ");
            return buildSql.toString();
        }
        return originalSql;
    }

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            return sqlFormatter.format(boundSql);
        }
        return boundSql.replaceAll("[\\s]+", " ");
    }

    public static String concatLike(String str, SqlLike type) {
        StringBuilder builder = new StringBuilder(str.length() + 3);
        switch (type) {
            case LEFT: {
                builder.append("%").append(str);
                break;
            }
            case RIGHT: {
                builder.append(str).append("%");
                break;
            }
            case CUSTOM: {
                builder.append(str);
                break;
            }
            default: {
                builder.append("%").append(str).append("%");
            }
        }
        return builder.toString();
    }
}

