/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import java.util.List;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.spi.DefaultApplicationContext;

public class ElasticSearchHelper {
    protected static DefaultApplicationContext context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml");
    public static final String DEFAULT_SEARCH = "elasticSearch";
    protected static ElasticSearch elasticSearchSink = null;

    protected static void init() {
        if (elasticSearchSink == null) {
            elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(DEFAULT_SEARCH, ElasticSearch.class));
        }
    }

    public static ElasticSearch getElasticSearchSink(String elasticSearch) {
        if (elasticSearch == null || elasticSearch.equals("")) {
            ElasticSearchHelper.init();
            return elasticSearchSink;
        }
        ElasticSearch elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(elasticSearch, ElasticSearch.class));
        return elasticSearchSink;
    }

    public static ElasticSearch getElasticSearchSink() {
        ElasticSearchHelper.init();
        return elasticSearchSink;
    }

    public static ClientInterface getRestClientUtil() {
        ElasticSearchHelper.init();
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getRestClientUtil(String elasticSearch) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getConfigRestClientUtil(String configFile) {
        ElasticSearchHelper.init();
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static ClientInterface getConfigRestClientUtil(String elasticSearch, String configFile) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static void addHttpServer(List<String> hosts) {
    }
}

