/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import org.frameworkset.elasticsearch.client.ClientInterface;

public abstract class ClientUtil
implements ClientInterface {
    public static Long longValue(Object num, Long defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Long) {
            return (Long)num;
        }
        if (num instanceof Double) {
            return ((Double)num).longValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).longValue();
        }
        if (num instanceof Float) {
            return ((Float)num).longValue();
        }
        if (num instanceof Short) {
            return ((Short)num).longValue();
        }
        return Long.parseLong(num.toString());
    }

    public static Integer intValue(Object num, Integer defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Integer) {
            return (Integer)num;
        }
        if (num instanceof Long) {
            return ((Long)num).intValue();
        }
        if (num instanceof Double) {
            return ((Double)num).intValue();
        }
        if (num instanceof Float) {
            return ((Float)num).intValue();
        }
        if (num instanceof Short) {
            return ((Short)num).intValue();
        }
        return Integer.parseInt(num.toString());
    }

    public static Float floatValue(Object num, Float defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Float) {
            return (Float)num;
        }
        if (num instanceof Double) {
            return Float.valueOf(((Double)num).floatValue());
        }
        if (num instanceof Integer) {
            return Float.valueOf(((Integer)num).floatValue());
        }
        if (num instanceof Long) {
            return Float.valueOf(((Long)num).floatValue());
        }
        if (num instanceof Short) {
            return Float.valueOf(((Short)num).floatValue());
        }
        return Float.valueOf(Float.parseFloat(num.toString()));
    }

    public static Double doubleValue(Object num, Double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Double) {
            return (Double)num;
        }
        if (num instanceof Float) {
            return ((Float)num).doubleValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).doubleValue();
        }
        if (num instanceof Long) {
            return ((Long)num).doubleValue();
        }
        if (num instanceof Short) {
            return ((Short)num).doubleValue();
        }
        return Double.parseDouble(num.toString());
    }

    public static String handleLuceneSpecialChars(String condition) {
        if (condition == null || condition.equals("")) {
            return condition;
        }
        condition = condition.replace(":", "/:");
        condition = condition.replace("-", "/-");
        condition = condition.replace("+", "/+");
        condition = condition.replace("&", "/&");
        condition = condition.replace("!", "/!");
        condition = condition.replace("{", "/{");
        condition = condition.replace("}", "/}");
        condition = condition.replace("(", "/(");
        condition = condition.replace(")", "/)");
        condition = condition.replace("|", "/|");
        condition = condition.replace("~", "/~");
        condition = condition.replace("*", "/*");
        condition = condition.replace("?", "/?");
        condition = condition.replace("/", "//");
        return condition;
    }

    public static String handleElasticSearchSpecialChars(String condition) {
        if (condition == null || condition.equals("")) {
            return condition;
        }
        condition = condition.replace(":", "\\\\:");
        condition = condition.replace("-", "\\\\-");
        condition = condition.replace("+", "\\\\+");
        condition = condition.replace("&", "\\\\&");
        condition = condition.replace("!", "\\\\!");
        condition = condition.replace("{", "\\\\{");
        condition = condition.replace("}", "\\\\}");
        condition = condition.replace("(", "\\\\(");
        condition = condition.replace(")", "\\\\)");
        condition = condition.replace("|", "\\\\|");
        condition = condition.replace("~", "\\\\~");
        condition = condition.replace("*", "\\\\*");
        condition = condition.replace("?", "\\\\?");
        condition = condition.replace("/", "\\\\/");
        return condition;
    }
}

