/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import com.frameworkset.util.VariableHandler;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.ESTemplate;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.spi.remote.http.MapResponseHandler;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRestClientUtil
extends RestClientUtil {
    private static Logger logger = LoggerFactory.getLogger(ConfigRestClientUtil.class);
    private static String java_date_format = "yyyy-MM-dd HH:mm:ss";
    private String configFile;
    private ESUtil esUtil = null;

    public ConfigRestClientUtil(ElasticSearchClient client, IndexNameBuilder indexNameBuilder, String configFile) {
        super(client, indexNameBuilder);
        this.configFile = configFile;
        this.esUtil = ESUtil.getInstance(configFile);
    }

    @Override
    public Object executeRequest(String path) throws ElasticSearchException {
        return this.executeRequest(path, null);
    }

    public Object execute() throws ElasticSearchException {
        return this.client.execute(this.bulkBuilder.toString());
    }

    private Object getId(Object bean) {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        ClassUtil.PropertieDescription pkProperty = beanInfo.getPkProperty();
        if (pkProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, pkProperty.getName());
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, addTemplate, beans, null);
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            this.evalBuilkTemplate(builder, indexName, indexType, addTemplate, bean, "index");
        }
        if (refreshOption == null) {
            return this.client.executeHttp("_bulk", builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            this.evalBuilkTemplate(builder, indexName, indexType, updateTemplate, bean, "update");
        }
        return this.client.executeHttp("_bulk", builder.toString(), "post");
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            this.evalBuilkTemplate(builder, indexName, indexType, updateTemplate, bean, "update");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, beans);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, beans, refreshOption);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, addTemplate, bean, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        Object id = this.getId(bean);
        builder.append(indexName).append("/").append(indexType);
        if (id != null) {
            builder.append("/").append(id);
        }
        if (refreshOption != null) {
            builder.append("?").append(refreshOption);
        }
        String path = builder.toString();
        builder.setLength(0);
        path = this.client.executeHttp(path, this.evalDocumentTemplate(builder, indexType, indexName, addTemplate, bean, "create"), "post");
        builder = null;
        return path;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, bean);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, bean, refreshOption);
    }

    private String evalTemplate(String templateName, Map params) {
        ESInfo esInfo = this.esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + this.esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null || params.size() == 0) {
            return esInfo.getTemplate();
        }
        String template = null;
        if (esInfo.isTpl()) {
            ESTemplate esTemplate = esInfo.getEstpl();
            esTemplate.process();
            if (esInfo.isTpl()) {
                VelocityContext vcontext = this.esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter();
                esTemplate.merge((Context)vcontext, (Writer)sw);
                StringBuilder builder = new StringBuilder();
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                template = this.evalDocumentStruction(builder, struction, params, templateName, null, false);
            } else {
                StringBuilder builder = new StringBuilder();
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
                template = this.evalDocumentStruction(builder, struction, params, templateName, null, true);
            }
        } else {
            StringBuilder builder = new StringBuilder();
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            template = this.evalDocumentStruction(builder, struction, params, templateName, null, true);
        }
        return template;
    }

    private String evalTemplate(String templateName, Object params) {
        ESInfo esInfo = this.esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + this.esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null) {
            return esInfo.getTemplate();
        }
        String template = null;
        if (esInfo.isTpl()) {
            esInfo.getEstpl().process();
            if (esInfo.isTpl()) {
                VelocityContext vcontext = this.esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter();
                esInfo.getEstpl().merge((Context)vcontext, (Writer)sw);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                StringBuilder builder = new StringBuilder();
                template = this.evalDocumentStruction(builder, struction, vcontext.getContext(), templateName, null, false);
            } else {
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
                StringBuilder builder = new StringBuilder();
                template = this.evalDocumentStruction(builder, struction, params, templateName, null);
            }
        } else {
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            StringBuilder builder = new StringBuilder();
            template = this.evalDocumentStruction(builder, struction, params, templateName, null);
        }
        return template;
    }

    private void buildMeta(StringBuilder builder, String indexType, String indexName, String templateName, Object params, String action) {
        Object id = this.getId(params);
        if (id != null) {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
        } else {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\" } }\n");
        }
    }

    private void evalBuilkTemplate(StringBuilder builder, String indexName, String indexType, String templateName, Object params, String action) {
        ESInfo esInfo = this.esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + this.esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null) {
            this.buildMeta(builder, indexType, indexName, templateName, params, action);
            if (!action.equals("update")) {
                builder.append(esInfo.getTemplate()).append("\n");
            } else {
                builder.append("{\"doc\":").append(esInfo.getTemplate()).append("}\n");
            }
        }
        if (esInfo.isTpl()) {
            esInfo.getEstpl().process();
            if (esInfo.isTpl()) {
                this.buildMeta(builder, indexType, indexName, templateName, params, action);
                VelocityContext vcontext = this.esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter();
                esInfo.getEstpl().merge((Context)vcontext, (Writer)sw);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                this.evalStruction(builder, struction, vcontext.getContext(), templateName, action, false);
            } else {
                this.buildMeta(builder, indexType, indexName, templateName, params, action);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
                this.evalStruction(builder, struction, params, templateName, action);
            }
        } else {
            this.buildMeta(builder, indexType, indexName, templateName, params, action);
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            this.evalStruction(builder, struction, params, templateName, action);
        }
    }

    private String evalDocumentTemplate(StringBuilder builder, String indexType, String indexName, String templateName, Object params, String action) {
        ESInfo esInfo = this.esUtil.getESInfo(templateName);
        if (esInfo == null) {
            throw new ElasticSearchException("ElasticSearch Template [" + templateName + "]@" + this.esUtil.getRealTemplateFile() + " \u672a\u5b9a\u4e49.");
        }
        if (params == null) {
            return esInfo.getTemplate();
        }
        if (esInfo.isTpl()) {
            esInfo.getEstpl().process();
            if (esInfo.isTpl()) {
                VelocityContext vcontext = this.esUtil.buildVelocityContext(params);
                BBossStringWriter sw = new BBossStringWriter(builder);
                esInfo.getEstpl().merge((Context)vcontext, (Writer)sw);
                VariableHandler.URLStruction struction = esInfo.getTemplateStruction(sw.toString());
                builder.setLength(0);
                return this.evalDocumentStruction(builder, struction, vcontext.getContext(), templateName, action, false);
            }
            VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
            return this.evalDocumentStruction(builder, struction, params, templateName, action);
        }
        VariableHandler.URLStruction struction = esInfo.getTemplateStruction(esInfo.getTemplate());
        return this.evalDocumentStruction(builder, struction, params, templateName, action);
    }

    private void evalStruction(StringBuilder builder, VariableHandler.URLStruction struction, Object params, String templateName, String action) {
        if (!struction.hasVars()) {
            if (!action.equals("update")) {
                builder.append(struction.getUrl()).append("\n");
            } else {
                builder.append("{\"doc\":").append(struction.getUrl()).append("}\n");
            }
        } else if (!action.equals("update")) {
            this.esUtil.evalStruction(builder, struction, params, templateName);
            builder.append("\n");
        } else {
            builder.append("{\"doc\":");
            this.esUtil.evalStruction(builder, struction, params, templateName);
            builder.append("}\n");
        }
    }

    private void evalStruction(StringBuilder builder, VariableHandler.URLStruction struction, Map params, String templateName, String action, boolean escapeValue) {
        if (!struction.hasVars()) {
            if (!action.equals("update")) {
                builder.append(struction.getUrl()).append("\n");
            } else {
                builder.append("{\"doc\":").append(struction.getUrl()).append("}\n");
            }
        } else if (!action.equals("update")) {
            this.esUtil.evalStruction(builder, struction, params, templateName, escapeValue);
            builder.append("\n");
        } else {
            builder.append("{\"doc\":");
            this.esUtil.evalStruction(builder, struction, params, templateName, escapeValue);
            builder.append("}\n");
        }
    }

    private String evalDocumentStruction(StringBuilder builder, VariableHandler.URLStruction struction, Map params, String templateName, String action, boolean escapeValue) {
        if (!struction.hasVars()) {
            return struction.getUrl();
        }
        this.esUtil.evalStruction(builder, struction, params, templateName, escapeValue);
        return builder.toString();
    }

    private String evalDocumentStruction(StringBuilder builder, VariableHandler.URLStruction struction, Object params, String templateName, String action) {
        if (!struction.hasVars()) {
            return struction.getUrl();
        }
        this.esUtil.evalStruction(builder, struction, params, templateName);
        return builder.toString();
    }

    @Override
    public String executeRequest(String path, String templateName) throws ElasticSearchException {
        return super.executeRequest(path, this.evalTemplate(templateName, null));
    }

    @Override
    public String executeRequest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.executeRequest(path, this.evalTemplate(templateName, params));
    }

    @Override
    public String executeRequest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.executeRequest(path, this.evalTemplate(templateName, params));
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, this.evalTemplate(templateName, params), responseHandler);
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Object params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, this.evalTemplate(templateName, params), responseHandler);
    }

    @Override
    public String delete(String path, String string) {
        return super.delete(path, string);
    }

    @Override
    public String executeHttp(String path, String templateName, String action) throws ElasticSearchException {
        return super.executeHttp(path, this.evalTemplate(templateName, (Object)null), action);
    }

    @Override
    public <T> T executeRequest(String path, String templateName, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, this.evalTemplate(templateName, (Object)null), responseHandler);
    }

    @Override
    public MapRestResponse search(String path, String templateName, Map params) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, params));
    }

    @Override
    public MapRestResponse search(String path, String templateName, Object params) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, params));
    }

    @Override
    public MapRestResponse search(String path, String templateName) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, (Object)null));
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Class<?> type) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, (Object)null), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, this.evalTemplate(templateName, null), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, this.evalTemplate(templateName, (Object)null), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, ESTypeReferences type) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, ESTypeReferences type) throws ElasticSearchException {
        return super.search(path, this.evalTemplate(templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, ESTypeReferences type) throws ElasticSearchException {
        return this.client.executeRequest(path, this.evalTemplate(templateName, (Object)null), new ElasticSearchResponseHandler(type));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName) throws ElasticSearchException {
        return super.updateIndiceMapping(action, this.evalTemplate(templateName, (Object)null));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, this.evalTemplate(templateName, (Object)null));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Object parameter) throws ElasticSearchException {
        return super.updateIndiceMapping(action, this.evalTemplate(templateName, parameter));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Object parameter) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, this.evalTemplate(templateName, parameter));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Map parameter) throws ElasticSearchException {
        return super.updateIndiceMapping(action, this.evalTemplate(templateName, parameter));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Map parameter) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, this.evalTemplate(templateName, parameter));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Map params) throws ElasticSearchException {
        return super.searchMap(path, this.evalTemplate(templateName, params));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Object params) throws ElasticSearchException {
        return super.searchMap(path, this.evalTemplate(templateName, params));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName) throws ElasticSearchException {
        return (Map)super.executeRequest(path, this.evalTemplate(templateName, (Object)null), new MapResponseHandler());
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, this.evalTemplate(templateName, params), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, this.evalTemplate(templateName, params), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, this.evalTemplate(templateName, (Object)null), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, this.evalTemplate(templateName, params), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, this.evalTemplate(templateName, params), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, this.evalTemplate(templateName, (Object)null), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public String createTempate(String template, String templateName) throws ElasticSearchException {
        return super.createTempate(template, this.evalTemplate(templateName, (Object)null));
    }

    @Override
    public String createTempate(String template, String templateName, Object params) throws ElasticSearchException {
        return super.createTempate(template, this.evalTemplate(templateName, params));
    }

    @Override
    public String createTempate(String template, String templateName, Map params) throws ElasticSearchException {
        return super.createTempate(template, this.evalTemplate(templateName, (Object)params));
    }
}

