/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

public class ESAddress {
    private String address;
    private String healthPath;
    private transient Thread healthCheck;
    private volatile int status = 0;

    public ESAddress() {
    }

    public String getHealthPath() {
        return this.healthPath;
    }

    public void setHealthPath(String healthPath) {
        this.healthPath = healthPath;
    }

    public ESAddress(String address) {
        if (!address.contains("http://") && !address.contains("https://")) {
            address = "http://" + address;
        }
        this.address = address;
        this.healthPath = this.getPath(address, "/");
    }

    private String getPath(String host, String path) {
        String url = path.equals("") || path.startsWith("/") ? host + path : host + "/" + path;
        return url;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.healthPath = this.getPath(address, "/");
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        this.status = status;
        if (status == 1 && this.healthCheck != null) {
            Thread thread = this.healthCheck;
            synchronized (thread) {
                this.healthCheck.notifyAll();
            }
        }
    }

    public void onlySetStatus(int status) {
        this.status = status;
    }

    public String toString() {
        return this.address;
    }

    public boolean ok() {
        return this.status == 0;
    }

    public void setHealthCheck(Thread healthCheck) {
        this.healthCheck = healthCheck;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ESAddress) {
            String other = ((ESAddress)obj).getAddress();
            return other != null && other.equals(this.getAddress());
        }
        return false;
    }
}

