/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.ResponseHandler;
import org.apache.http.conn.HttpHostConnectException;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.ConfigRestClientUtil;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.HealthCheck;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.client.RoundRobinList;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.StringResponseHandler;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClient
implements ElasticSearchClient {
    public static final String INDEX_OPERATION_NAME = "index";
    public static final String INDEX_PARAM = "_index";
    public static final String TYPE_PARAM = "_type";
    public static final String TTL_PARAM = "_ttl";
    public static final String BULK_ENDPOINT = "_bulk";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestClient.class);
    protected final RoundRobinList serversList;
    protected Properties extendElasticsearchPropes;
    protected String httpPool;
    protected String elasticUser;
    protected String elasticPassword;
    protected long healthCheckInterval = -1L;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected boolean showTemplate = false;
    protected List<ESAddress> addressList;
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy.MM.dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    protected String dateFormat = "yyyy.MM.dd";
    protected TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
    protected ElasticSearch elasticSearch;

    public ElasticSearchRestClient(ElasticSearch elasticSearch, String[] hostNames, String elasticUser, String elasticPassword, Properties extendElasticsearchPropes) {
        this.extendElasticsearchPropes = extendElasticsearchPropes;
        this.elasticSearch = elasticSearch;
        this.addressList = new ArrayList<ESAddress>();
        for (String host : hostNames) {
            this.addressList.add(new ESAddress(host));
        }
        this.serversList = new RoundRobinList(this.addressList);
        this.elasticUser = elasticUser;
        this.elasticPassword = elasticPassword;
        this.init();
    }

    private boolean containAddress(ESAddress address) {
        ESAddress temp = null;
        for (int i = 0; i < this.addressList.size(); ++i) {
            temp = this.addressList.get(i);
            if (!temp.equals(address)) continue;
            return true;
        }
        return false;
    }

    public void addAddress(String[] address) {
        ArrayList<ESAddress> temp = new ArrayList<ESAddress>();
        for (String host : address) {
            ESAddress esAddress = new ESAddress(host);
            if (this.containAddress(esAddress)) continue;
            temp.add(new ESAddress(host));
        }
        if (temp.size() > 0) {
            this.serversList.addAddress(temp);
        }
    }

    @Override
    public void init() {
        if (this.elasticUser != null && !this.elasticUser.equals("")) {
            this.headers.put("Authorization", ElasticSearchRestClient.getHeader(this.elasticUser, this.elasticPassword));
        }
        if (this.healthCheckInterval > 0L) {
            logger.info("start elastic healthCheck thread,you can set elasticsearch.healthCheckInterval=-1 in " + this.elasticSearch.getApplicationContext().getConfigfile() + " to disable healthCheck thread.");
            HealthCheck healthCheck = new HealthCheck(this.addressList, this.healthCheckInterval, this.headers);
            healthCheck.run();
        }
    }

    public static String getHeader(String user, String password) {
        String auth = user + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("US-ASCII")));
        return "Basic " + new String(encodedAuth);
    }

    @Override
    public void configure(Properties elasticsearchPropes) {
        String dateFormatString = elasticsearchPropes.getProperty("elasticsearch.dateFormat");
        String timeZoneString = elasticsearchPropes.getProperty("elasticsearch.timeZone");
        String showTemplate_ = elasticsearchPropes.getProperty("elasticsearch.showTemplate");
        String httpPool = elasticsearchPropes.getProperty("elasticsearch.httpPool");
        if (httpPool == null || httpPool.equals("")) {
            httpPool = "default";
        }
        if (showTemplate_ != null && showTemplate_.equals("true")) {
            this.showTemplate = true;
        }
        if (SimpleStringUtil.isEmpty((String)dateFormatString)) {
            dateFormatString = "yyyy.MM.dd";
        }
        if (SimpleStringUtil.isEmpty((String)timeZoneString)) {
            timeZoneString = "";
        }
        this.dateFormat = dateFormatString;
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        String healthCheckInterval_ = elasticsearchPropes.getProperty("elasticsearch.healthCheckInterval");
        if (healthCheckInterval_ == null) {
            this.healthCheckInterval = 3000L;
        } else {
            try {
                this.healthCheckInterval = Long.parseLong(healthCheckInterval_);
            }
            catch (Exception e) {
                logger.error("Parse Long healthCheckInterval parameter failed:" + healthCheckInterval_, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
    }

    public String execute(String entity) throws ElasticSearchException {
        int triesCount = 0;
        String response = null;
        Throwable e = null;
        while (true) {
            ESAddress host = this.serversList.get();
            String url = host.getAddress() + "/" + BULK_ENDPOINT;
            try {
                if (this.showTemplate && logger.isInfoEnabled()) {
                    logger.info(entity);
                }
                response = HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (IOException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (ElasticSearchException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw e;
            }
            throw new ElasticSearchException(e);
        }
        return response;
    }

    @Override
    public ClientUtil getClientUtil(IndexNameBuilder indexNameBuilder) {
        return new RestClientUtil(this, indexNameBuilder);
    }

    @Override
    public ClientUtil getConfigClientUtil(IndexNameBuilder indexNameBuilder, String configFile) {
        return new ConfigRestClientUtil(this, indexNameBuilder, configFile);
    }

    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.executeHttp(path, null, action);
    }

    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeHttp(path, null, action, responseHandler);
    }

    private String getPath(String host, String path) {
        String url = path.equals("") || path.startsWith("/") ? host + path : host + "/" + path;
        return url;
    }

    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        int triesCount = 0;
        Object response = null;
        Throwable e = null;
        if (this.showTemplate && logger.isInfoEnabled()) {
            logger.info("Elastic search action:{},request body:{}", (Object)path, (Object)entity);
        }
        while (true) {
            ESAddress host = this.serversList.get();
            String url = this.getPath(host.getAddress(), path);
            try {
                if (entity == null) {
                    if (action == null) {
                        response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    if (action == "post") {
                        response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    if (action == "put") {
                        response = HttpRequestUtil.httpPutforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    if (action == "get") {
                        response = HttpRequestUtil.httpGetforString((String)this.httpPool, (String)url, this.headers, responseHandler);
                        break;
                    }
                    if (action == "delete") {
                        response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    throw new IllegalArgumentException("not support http action:" + action);
                }
                if (action == "post") {
                    response = HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
                    break;
                }
                if (action == "put") {
                    response = HttpRequestUtil.putJson((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
                    break;
                }
                throw new IllegalArgumentException("not support http action:" + action);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (IOException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (ElasticSearchException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw e;
            }
            throw new ElasticSearchException(e);
        }
        return (T)response;
    }

    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return (String)this.executeHttp(path, entity, action, (ResponseHandler)new StringResponseHandler());
    }

    public String executeRequest(String path, String entity) throws ElasticSearchException {
        int triesCount = 0;
        String response = null;
        Throwable e = null;
        if (this.showTemplate && logger.isInfoEnabled()) {
            logger.info("Elastic search action:{},request body:\n{}", (Object)path, (Object)entity);
        }
        while (true) {
            ESAddress host = this.serversList.get();
            String url = this.getPath(host.getAddress(), path);
            try {
                if (entity == null) {
                    response = HttpRequestUtil.httpPostforString((String)url, null, this.headers);
                    break;
                }
                response = HttpRequestUtil.sendJsonBody((String)entity, (String)url, this.headers);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (IOException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (ElasticSearchException ex) {
                throw ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            throw new ElasticSearchException(e);
        }
        return response;
    }

    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeRequest(path, entity, responseHandler, "post");
    }

    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler, String action) throws ElasticSearchException {
        Object response = null;
        int triesCount = 0;
        Throwable e = null;
        if (this.showTemplate && logger.isInfoEnabled()) {
            logger.info("Elastic search action:{},request body:\n{}", (Object)path, (Object)entity);
        }
        while (true) {
            ESAddress host = this.serversList.get();
            String url = this.getPath(host.getAddress(), path);
            try {
                if (entity == null) {
                    if (action == null) {
                        response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    if (action == "post") {
                        response = HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    if (action == "put") {
                        response = HttpRequestUtil.httpPutforString((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    if (action == "get") {
                        response = HttpRequestUtil.httpGetforString((String)this.httpPool, (String)url, this.headers, responseHandler);
                        break;
                    }
                    if (action == "delete") {
                        response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                        break;
                    }
                    throw new IllegalArgumentException("not support http action:" + action);
                }
                if (action == "post") {
                    response = HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
                    break;
                }
                if (action == "put") {
                    response = HttpRequestUtil.putJson((String)this.httpPool, (String)entity, (String)url, this.headers, responseHandler);
                    break;
                }
                if (action == "delete") {
                    response = HttpRequestUtil.httpDelete((String)this.httpPool, (String)url, null, this.headers, responseHandler);
                    break;
                }
                throw new IllegalArgumentException("not support http action:" + action);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (IOException ex) {
                host.setStatus(1);
                if (triesCount < this.serversList.size()) {
                    ++triesCount;
                    continue;
                }
                e = ex;
            }
            catch (ElasticSearchException ex) {
                throw ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            catch (Throwable ex) {
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e);
        }
        return (T)response;
    }

    public FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isShowTemplate() {
        return this.showTemplate;
    }

    public void setShowTemplate(boolean showTemplate) {
        this.showTemplate = showTemplate;
    }
}

