/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck
implements Runnable {
    private List<ESAddress> esAddresses;
    private static final String healthCheckHttpPool = "healthCheckHttpPool";
    private static Logger logger = LoggerFactory.getLogger(HealthCheck.class);
    private long checkInterval = 5000L;
    private List<HCRunable> checkThreads;
    private Map<String, String> headers;

    public HealthCheck(List<ESAddress> esAddresses, long checkInterval, Map<String, String> headers) {
        this.esAddresses = esAddresses;
        this.checkInterval = checkInterval;
        this.headers = headers;
    }

    public void stopCheck() {
        HCRunable t = null;
        for (int i = 0; i < this.checkThreads.size(); ++i) {
            t = this.checkThreads.get(i);
            t.stopRun();
        }
    }

    @Override
    public void run() {
        Iterator<ESAddress> iterable = this.esAddresses.iterator();
        this.checkThreads = new ArrayList<HCRunable>();
        HCRunable t = null;
        ESAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
        BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                HealthCheck.this.stopCheck();
            }
        });
    }

    public void addNewAddress(List<ESAddress> addresses) {
        Iterator<ESAddress> iterable = addresses.iterator();
        HCRunable t = null;
        ESAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    class HCRunable
    extends Thread {
        ESAddress address;
        boolean stop;

        public HCRunable(ESAddress address) {
            super("Elasticsearch server[" + address.toString() + "] health check");
            this.stop = false;
            address.setHealthCheck(this);
            this.address = address;
        }

        public void stopRun() {
            this.stop = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                if (!this.address.ok()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Check dead elasticsearch server[" + this.address.toString() + "] status.");
                        }
                        HttpRequestUtil.httpGet((String)HealthCheck.healthCheckHttpPool, (String)this.address.getHealthPath(), (Map)HealthCheck.this.headers, (ResponseHandler)new ResponseHandler<Void>(){

                            public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                                int status = response.getStatusLine().getStatusCode();
                                if (status >= 200 && status < 300) {
                                    if (logger.isInfoEnabled()) {
                                        logger.info("Dead elasticsearch server[" + HCRunable.this.address.toString() + "] recovered to normal server.");
                                    }
                                    HCRunable.this.address.onlySetStatus(0);
                                } else {
                                    HCRunable.this.address.onlySetStatus(1);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Elasticsearch server[" + this.address.toString() + "] is dead.");
                        }
                        this.address.onlySetStatus(1);
                    }
                    if (this.stop) break;
                    try {
                        HCRunable.sleep(HealthCheck.this.checkInterval);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                try {
                    HCRunable e = this;
                    synchronized (e) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

