/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.ElasticSearchRestClient;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.DoubleAggHit;
import org.frameworkset.elasticsearch.entity.DoubleAggRangeHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESBaseData;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.ESId;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.FloatAggHit;
import org.frameworkset.elasticsearch.entity.FloatAggRangeHit;
import org.frameworkset.elasticsearch.entity.IndexField;
import org.frameworkset.elasticsearch.entity.LongAggHit;
import org.frameworkset.elasticsearch.entity.LongAggRangeHit;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.entity.MapSearchHit;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.SearchHit;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.handler.ElasticSearchMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentHitResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentResponseHandler;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.json.JsonTypeReference;
import org.frameworkset.spi.remote.http.MapResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientUtil
extends ClientUtil {
    private static Logger logger = LoggerFactory.getLogger(RestClientUtil.class);
    protected ElasticSearchRestClient client;
    protected StringBuilder bulkBuilder;
    protected IndexNameBuilder indexNameBuilder;

    public RestClientUtil(ElasticSearchClient client, IndexNameBuilder indexNameBuilder) {
        this.client = (ElasticSearchRestClient)client;
        this.indexNameBuilder = indexNameBuilder;
    }

    private void handleFields(Map<String, Object> subFileds, String fieldName, List<IndexField> fields) {
        if (subFileds == null || subFileds.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : subFileds.entrySet()) {
            IndexField indexField = this.buildIndexField(entry, fields, fieldName);
        }
    }

    private Boolean parseBoolean(Object norms) {
        if (norms == null) {
            return null;
        }
        if (norms instanceof Boolean) {
            return (Boolean)norms;
        }
        if (norms instanceof Map) {
            return (Boolean)((Map)norms).get("enabled");
        }
        return null;
    }

    private IndexField buildIndexField(Map.Entry<String, Object> field, List<IndexField> fields, String parentFieldName) {
        IndexField indexField = new IndexField();
        String fieldName = null;
        fieldName = parentFieldName != null ? parentFieldName + "." + field.getKey() : field.getKey();
        indexField.setFieldName(fieldName);
        Map fieldInfo = (Map)field.getValue();
        indexField.setType((String)fieldInfo.get("type"));
        indexField.setIgnoreAbove(ClientUtil.intValue(fieldInfo.get("ignore_above"), null));
        indexField.setAnalyzer((String)fieldInfo.get("analyzer"));
        indexField.setNormalizer((String)fieldInfo.get("normalizer"));
        indexField.setBoost((Integer)fieldInfo.get("boost"));
        indexField.setCoerce(this.parseBoolean(fieldInfo.get("coerce")));
        indexField.setCopyTo((String)fieldInfo.get("copy_to"));
        indexField.setDocValues(this.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setDynamic(this.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setEnabled(this.parseBoolean(fieldInfo.get("enabled")));
        indexField.setFielddata(this.parseBoolean(fieldInfo.get("fielddata")));
        indexField.setFormat((String)fieldInfo.get("format"));
        indexField.setIgnoreMalformed(this.parseBoolean(fieldInfo.get("ignore_malformed")));
        indexField.setIncludeInAll(this.parseBoolean(fieldInfo.get("include_in_all")));
        indexField.setIndexOptions((String)fieldInfo.get("index_options"));
        indexField.setIndex(this.parseBoolean(fieldInfo.get("index")));
        indexField.setFields((Map)fieldInfo.get("fields"));
        indexField.setNorms(this.parseBoolean(fieldInfo.get("norms")));
        indexField.setNullValue(fieldInfo.get("null_value"));
        indexField.setPositionIncrementGap((Integer)fieldInfo.get("position_increment_gap"));
        indexField.setProperties((Map)fieldInfo.get("properties"));
        indexField.setSearchAnalyzer((String)fieldInfo.get("search_analyzer"));
        indexField.setSimilarity((String)fieldInfo.get("similarity"));
        indexField.setStore(this.parseBoolean(fieldInfo.get("store")));
        indexField.setTermVector((String)fieldInfo.get("term_vector"));
        fields.add(indexField);
        this.handleFields(indexField.getFields(), fieldName, fields);
        return indexField;
    }

    @Override
    public List<IndexField> getIndexMappingFields(String index, final String indexType) throws ElasticSearchException {
        final ArrayList<IndexField> fields = new ArrayList<IndexField>();
        this.getIndexMapping(index, false, new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    Map map = (Map)SimpleStringUtil.json2ObjectWithType((InputStream)entity.getContent(), (JsonTypeReference)new JsonTypeReference<Map<String, Object>>(){});
                    Iterator entries = map.entrySet().iterator();
                    if (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        Map mapping = (Map)entry.getValue();
                        Map typeProperties = (Map)((Map)mapping.get("mappings")).get(indexType);
                        Map properties = (Map)typeProperties.get("properties");
                        for (Map.Entry field : properties.entrySet()) {
                            IndexField indexField = RestClientUtil.this.buildIndexField(field, fields, null);
                        }
                    }
                    return null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    throw new ElasticSearchException("Unexpected response : " + EntityUtils.toString((HttpEntity)entity));
                }
                throw new ElasticSearchException("Unexpected response status: " + status);
            }
        });
        return fields;
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Object executeRequest(String path) throws ElasticSearchException {
        return this.executeRequest(path, null);
    }

    @Override
    public String deleteDocuments(String indexName, String indexType, String ... ids) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (String id : ids) {
            builder.append("{ \"delete\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
        }
        return this.client.executeHttp("_bulk", builder.toString(), "post");
    }

    @Override
    public String deleteDocumentsWithrefreshOption(String indexName, String indexType, String refreshOption, String ... ids) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (String id : ids) {
            builder.append("{ \"delete\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String deleteTempate(String template) throws ElasticSearchException {
        return this.client.executeHttp("/_template/" + template, "delete");
    }

    @Override
    public String getTempate(String template) throws ElasticSearchException {
        return this.client.executeHttp("/_template/" + template, "get");
    }

    @Override
    public String getTempate() throws ElasticSearchException {
        return this.client.executeHttp("/_template", "get");
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getDocument(String indexName, String indexType, String documentId, Map<String, Object> options) throws ElasticSearchException {
        return this.client.executeHttp(this.buildGetDocumentRequest(indexName, indexType, documentId, options), "get");
    }

    private String buildGetDocumentRequest(String indexName, String indexType, String documentId, Map<String, Object> options) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(indexName).append("/").append(indexType).append("/").append(documentId);
        if (options != null) {
            builder.append("?");
            Iterator<Map.Entry<String, Object>> iterable = options.entrySet().iterator();
            boolean first = true;
            while (iterable.hasNext()) {
                Map.Entry<String, Object> entry = iterable.next();
                if (first) {
                    builder.append(entry.getKey()).append("=").append(entry.getValue());
                    first = false;
                    continue;
                }
                builder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    @Override
    public String getDocument(String indexName, String indexType, String documentId) throws ElasticSearchException {
        return this.getDocument(indexName, indexType, documentId, (Map<String, Object>)null);
    }

    @Override
    public <T> T getDocument(String indexName, String indexType, String documentId, Class<T> beanType) throws ElasticSearchException {
        return this.getDocument(indexName, indexType, documentId, null, beanType);
    }

    @Override
    public <T> T getDocument(String indexName, String indexType, String documentId, Map<String, Object> options, Class<T> beanType) throws ElasticSearchException {
        SearchHit searchResult = this.client.executeRequest(this.buildGetDocumentRequest(indexName, indexType, documentId, options), null, new GetDocumentResponseHandler(beanType), "get");
        return this.buildObject(searchResult, beanType);
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String indexType, String documentId, Map<String, Object> options) throws ElasticSearchException {
        MapSearchHit searchResult = this.client.executeRequest(this.buildGetDocumentRequest(indexName, indexType, documentId, options), null, new GetDocumentHitResponseHandler(), "get");
        return searchResult;
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String indexType, String documentId) throws ElasticSearchException {
        return this.getDocumentHit(indexName, indexType, documentId, null);
    }

    @Override
    public String deleteDocument(String indexName, String indexType, String id) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/" + indexType + "/" + id, "delete");
    }

    @Override
    public String deleteDocument(String indexName, String indexType, String id, String refreshOption) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/" + indexType + "/" + id + "?" + refreshOption, "delete");
    }

    @Override
    public String executeRequest(String path, String entity) throws ElasticSearchException {
        return this.client.executeRequest(path, entity);
    }

    @Override
    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeRequest(path, entity, responseHandler);
    }

    @Override
    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.client.executeHttp(path, action);
    }

    @Override
    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, action);
    }

    @Override
    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeHttp(path, action, responseHandler);
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, action, responseHandler);
    }

    @Override
    public String getIndexMapping(String index) throws ElasticSearchException {
        return this.getIndexMapping(index, true);
    }

    @Override
    public <T> T getIndexMapping(String index, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.getIndexMapping(index, true, responseHandler);
    }

    @Override
    public String getIndexMapping(String index, boolean pretty) throws ElasticSearchException {
        if (pretty) {
            return this.client.executeHttp(index + "/_mapping?pretty", "get");
        }
        return this.client.executeHttp(index + "/_mapping", "get");
    }

    @Override
    public <T> T getIndexMapping(String index, boolean pretty, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        if (pretty) {
            return this.client.executeRequest(index + "/_mapping?pretty", null, responseHandler, "get");
        }
        return this.client.executeRequest(index + "/_mapping", null, responseHandler, "get");
    }

    @Override
    public String delete(String path, String string) {
        return null;
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Object params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String entity) throws ElasticSearchException {
        MapRestResponse searchResult = this.client.executeRequest(path, entity, new ElasticSearchMapResponseHandler());
        return searchResult;
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String entity, Class<?> type) throws ElasticSearchException {
        RestResponse searchResult = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return searchResult;
    }

    protected <T> ESDatas<T> buildESDatas(RestResponse result, Class<T> type) {
        ESDatas datas = new ESDatas();
        RestResponse restResponse = result;
        datas.setTotalSize(restResponse.getSearchHits().getTotal());
        List<SearchHit> searchHits = restResponse.getSearchHits().getHits();
        ArrayList<Object> hits = new ArrayList<Object>(searchHits.size());
        boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
        boolean isESId = false;
        if (!isESBaseData) {
            isESId = ESId.class.isAssignableFrom(type);
        }
        Object data = null;
        for (SearchHit hit : searchHits) {
            data = hit.getSource();
            hits.add(data);
            if (isESBaseData) {
                this.buildESBaseData(hit, (ESBaseData)data);
                continue;
            }
            if (!isESId) continue;
            this.buildESId(hit, (ESId)data);
        }
        datas.setAggregations(restResponse.getAggregations());
        datas.setDatas(hits);
        return datas;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String entity, Class<T> type) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return this.buildESDatas(result, type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T searchObject(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    protected void buildESBaseData(SearchHit hit, ESBaseData esBaseData) {
        esBaseData.setFields(hit.getFields());
        esBaseData.setHighlight(hit.getHighlight());
        esBaseData.setId(hit.getId());
        esBaseData.setScore(hit.getScore());
        esBaseData.setSort(hit.getSort());
        esBaseData.setType(hit.getType());
        esBaseData.setVersion(hit.getVersion());
        esBaseData.setIndex(hit.getIndex());
    }

    protected void buildESId(SearchHit hit, ESId esBaseData) {
        esBaseData.setId(hit.getId());
    }

    protected <T> T buildObject(RestResponse result, Class<T> type) {
        if (result == null) {
            return null;
        }
        RestResponse restResponse = result;
        List<SearchHit> searchHits = restResponse.getSearchHits().getHits();
        if (searchHits != null && searchHits.size() > 0) {
            boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
            boolean isESId = false;
            if (!isESBaseData) {
                isESId = ESId.class.isAssignableFrom(type);
            }
            SearchHit hit = searchHits.get(0);
            Object data = hit.getSource();
            if (isESBaseData) {
                this.buildESBaseData(hit, (ESBaseData)data);
            } else if (isESId) {
                this.buildESId(hit, (ESId)data);
            }
            return (T)data;
        }
        return null;
    }

    protected <T> T buildObject(SearchHit result, Class<T> type) {
        SearchHit hit;
        if (result == null) {
            return null;
        }
        boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
        boolean isESId = false;
        if (!isESBaseData) {
            isESId = ESId.class.isAssignableFrom(type);
        }
        if ((hit = result).isFound()) {
            Object data = hit.getSource();
            if (isESBaseData) {
                this.buildESBaseData(hit, (ESBaseData)data);
            } else if (isESId) {
                this.buildESId(hit, (ESId)data);
            }
            return (T)data;
        }
        return null;
    }

    @Override
    public <T> T searchObject(String path, String entity, Class<T> type) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return this.buildObject(result, type);
    }

    private void buildLongAggHit(LongAggHit longRangeHit, Map<String, Object> bucket, String stats) {
        longRangeHit.setKey((String)bucket.get("key"));
        longRangeHit.setDocCount(RestClientUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        longRangeHit.setMax(RestClientUtil.longValue(stats_.get("max"), 0L));
        longRangeHit.setMin(RestClientUtil.longValue(stats_.get("min"), 0L));
        longRangeHit.setAvg(RestClientUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        longRangeHit.setSum(RestClientUtil.longValue(stats_.get("sum"), 0L));
    }

    private void buildFloatAggHit(FloatAggHit floatRangeHit, Map<String, Object> bucket, String stats) {
        floatRangeHit.setKey((String)bucket.get("key"));
        floatRangeHit.setDocCount(RestClientUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        floatRangeHit.setMax(RestClientUtil.floatValue(stats_.get("max"), Float.valueOf(0.0f)));
        floatRangeHit.setMin(RestClientUtil.floatValue(stats_.get("min"), Float.valueOf(0.0f)));
        floatRangeHit.setAvg(RestClientUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        floatRangeHit.setSum(RestClientUtil.floatValue(stats_.get("sum"), Float.valueOf(0.0f)));
    }

    private void buildDoubleAggHit(DoubleAggHit doubleAggHit, Map<String, Object> bucket, String stats) {
        doubleAggHit.setKey((String)bucket.get("key"));
        doubleAggHit.setDocCount(RestClientUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        doubleAggHit.setMax(RestClientUtil.doubleValue(stats_.get("max"), 0.0));
        doubleAggHit.setMin(RestClientUtil.doubleValue(stats_.get("min"), 0.0));
        doubleAggHit.setAvg(RestClientUtil.doubleValue(stats_.get("avg"), 0.0));
        doubleAggHit.setSum(RestClientUtil.doubleValue(stats_.get("sum"), 0.0));
    }

    private void buildLongAggRangeHit(LongAggRangeHit longRangeHit, Map<String, Object> bucket, String stats, String key) {
        longRangeHit.setKey(key);
        longRangeHit.setFrom(RestClientUtil.longValue(bucket.get("from"), null));
        longRangeHit.setTo(RestClientUtil.longValue(bucket.get("to"), null));
        longRangeHit.setDocCount(RestClientUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        longRangeHit.setMax(RestClientUtil.longValue(stats_.get("max"), 0L));
        longRangeHit.setMin(RestClientUtil.longValue(stats_.get("min"), 0L));
        longRangeHit.setAvg(RestClientUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        longRangeHit.setSum(RestClientUtil.longValue(stats_.get("sum"), 0L));
    }

    private void buildFloatAggRangeHit(FloatAggRangeHit floatRangeHit, Map<String, Object> bucket, String stats, String key) {
        floatRangeHit.setKey(key);
        floatRangeHit.setFrom(RestClientUtil.floatValue(bucket.get("from"), null));
        floatRangeHit.setTo(RestClientUtil.floatValue(bucket.get("to"), null));
        floatRangeHit.setDocCount(RestClientUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        floatRangeHit.setMax(RestClientUtil.floatValue(stats_.get("max"), Float.valueOf(0.0f)));
        floatRangeHit.setMin(RestClientUtil.floatValue(stats_.get("min"), Float.valueOf(0.0f)));
        floatRangeHit.setAvg(RestClientUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        floatRangeHit.setSum(RestClientUtil.floatValue(stats_.get("sum"), Float.valueOf(0.0f)));
    }

    private void buildDoubleAggRangeHit(DoubleAggRangeHit doubleRangeHit, Map<String, Object> bucket, String stats, String key) {
        doubleRangeHit.setKey(key);
        doubleRangeHit.setFrom(RestClientUtil.doubleValue(bucket.get("from"), null));
        doubleRangeHit.setTo(RestClientUtil.doubleValue(bucket.get("to"), null));
        doubleRangeHit.setDocCount(RestClientUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        doubleRangeHit.setMax(RestClientUtil.doubleValue(stats_.get("max"), 0.0));
        doubleRangeHit.setMin(RestClientUtil.doubleValue(stats_.get("min"), 0.0));
        doubleRangeHit.setAvg(RestClientUtil.doubleValue(stats_.get("avg"), 0.0));
        doubleRangeHit.setSum(RestClientUtil.doubleValue(stats_.get("sum"), 0.0));
    }

    protected <T extends AggHit> ESAggDatas<T> buildESAggDatas(RestResponse searchResult, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) {
        Map<String, Map<String, Object>> aggregations = searchResult.getAggregations();
        if (aggregations != null) {
            Map<String, Object> traces = aggregations.get(aggs);
            Object _buckets = traces.get("buckets");
            ESAggDatas ret = new ESAggDatas();
            ret.setTotalSize(searchResult.getSearchHits().getTotal());
            if (_buckets instanceof List) {
                List buckets = (List)_buckets;
                ArrayList<AggHit> datas = new ArrayList<AggHit>(buckets.size());
                ret.setAggDatas(datas);
                for (Map bucket : buckets) {
                    try {
                        AggHit obj = (AggHit)type.newInstance();
                        if (obj instanceof LongAggRangeHit) {
                            this.buildLongAggRangeHit((LongAggRangeHit)obj, bucket, stats, null);
                        } else if (obj instanceof FloatAggRangeHit) {
                            this.buildFloatAggRangeHit((FloatAggRangeHit)obj, bucket, stats, null);
                        } else if (obj instanceof DoubleAggRangeHit) {
                            this.buildDoubleAggRangeHit((DoubleAggRangeHit)obj, bucket, stats, null);
                        } else if (obj instanceof LongAggHit) {
                            this.buildLongAggHit((LongAggHit)obj, bucket, stats);
                        } else if (obj instanceof FloatAggHit) {
                            this.buildFloatAggHit((FloatAggHit)obj, bucket, stats);
                        } else if (obj instanceof DoubleAggHit) {
                            this.buildDoubleAggHit((DoubleAggHit)obj, bucket, stats);
                        }
                        if (aggBucketHandle != null) {
                            aggBucketHandle.bucketHandle(searchResult, bucket, obj, null);
                        }
                        datas.add(obj);
                    }
                    catch (InstantiationException e) {
                        throw new ElasticSearchException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ElasticSearchException(e);
                    }
                }
            } else {
                Map buckets = (Map)_buckets;
                ArrayList<AggHit> datas = new ArrayList<AggHit>(buckets.size());
                ret.setAggDatas(datas);
                Iterator iterable = buckets.entrySet().iterator();
                Map bucket = null;
                Map.Entry entry = null;
                String key = null;
                AggHit obj = null;
                while (iterable.hasNext()) {
                    entry = iterable.next();
                    key = (String)entry.getKey();
                    bucket = (Map)entry.getValue();
                    try {
                        obj = (AggHit)type.newInstance();
                        if (obj instanceof LongAggRangeHit) {
                            this.buildLongAggRangeHit((LongAggRangeHit)obj, bucket, stats, key);
                        } else if (obj instanceof DoubleAggRangeHit) {
                            this.buildDoubleAggRangeHit((DoubleAggRangeHit)obj, bucket, stats, key);
                        } else if (obj instanceof FloatAggRangeHit) {
                            this.buildFloatAggRangeHit((FloatAggRangeHit)obj, bucket, stats, key);
                        }
                        if (aggBucketHandle != null) {
                            aggBucketHandle.bucketHandle(searchResult, bucket, obj, key);
                        }
                        datas.add(obj);
                    }
                    catch (InstantiationException e) {
                        throw new ElasticSearchException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ElasticSearchException(e);
                    }
                }
            }
            return ret;
        }
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return this.buildESAggDatas(result, type, aggs, stats, null);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return this.buildESAggDatas(result, type, aggs, stats, aggBucketHandle);
    }

    @Override
    public String createTempate(String template, String entity) throws ElasticSearchException {
        return this.client.executeHttp("_template/" + template, entity, "put");
    }

    @Override
    public String createTempate(String template, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createTempate(String template, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, ESTypeReferences type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, ESTypeReferences type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String entity, ESTypeReferences type) throws ElasticSearchException {
        return this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Map<String, Object> searchMap(String path, String entity) throws ElasticSearchException {
        return (Map)this.client.executeRequest(path, entity, new MapResponseHandler());
    }

    @Override
    public String dropIndice(String index) throws ElasticSearchException {
        return this.client.executeHttp(index + "?pretty", "delete");
    }

    @Override
    public String updateIndiceMapping(String action, String indexMapping) throws ElasticSearchException {
        return this.client.executeHttp(action, indexMapping, "post");
    }

    @Override
    public String createIndiceMapping(String indexName, String indexMapping) throws ElasticSearchException {
        return this.client.executeHttp(indexName, indexMapping, "put");
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Object parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Object parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Map parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Map parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getIndice(String index) throws ElasticSearchException {
        return this.getIndexMapping(index, true);
    }

    @Override
    public List<ESIndice> getIndexes() throws ElasticSearchException {
        String data = this.client.executeHttp("_cat/indices?v", "get");
        logger.debug(data);
        if (SimpleStringUtil.isNotEmpty((String)data)) {
            try {
                List<ESIndice> indices = this.extractIndice(data);
                return indices;
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ESIndice> extractIndice(String data) throws IOException {
        StringReader reader = null;
        BufferedReader br = null;
        try {
            String line;
            reader = new StringReader(data);
            br = new BufferedReader(reader);
            ArrayList<ESIndice> indices = new ArrayList<ESIndice>();
            int i = 0;
            SimpleDateFormat format = new SimpleDateFormat(this.client.getDateFormat());
            while ((line = br.readLine()) != null) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                ESIndice esIndice = this.buildESIndice(line, format);
                indices.add(esIndice);
            }
            ArrayList<ESIndice> arrayList = indices;
            return arrayList;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ESIndice buildESIndice(String line, SimpleDateFormat format) {
        StringBuilder token = new StringBuilder();
        ESIndice esIndice = new ESIndice();
        int k = 0;
        block12: for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c != ' ') {
                token.append(c);
                continue;
            }
            if (token.length() == 0) continue;
            switch (k) {
                case 0: {
                    esIndice.setHealth(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 1: {
                    esIndice.setStatus(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 2: {
                    esIndice.setIndex(token.toString());
                    this.putGendate(esIndice, format);
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 3: {
                    esIndice.setUuid(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 4: {
                    esIndice.setPri(Integer.parseInt(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 5: {
                    esIndice.setRep(Integer.parseInt(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 6: {
                    esIndice.setDocsCcount(Long.parseLong(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 7: {
                    esIndice.setDocsDeleted(Long.parseLong(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 8: {
                    esIndice.setStoreSize(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 9: {
                    esIndice.setPriStoreSize(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
            }
        }
        esIndice.setPriStoreSize(token.toString());
        return esIndice;
    }

    private void putGendate(ESIndice esIndice, SimpleDateFormat format) {
        int dsplit = esIndice.getIndex().lastIndexOf(45);
        try {
            if (dsplit > 0) {
                String date = esIndice.getIndex().substring(dsplit + 1);
                esIndice.setGenDate((Date)format.parseObject(date));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String refreshIndexInterval(String indexName, int interval) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/_settings", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"   } }", "put");
    }

    @Override
    public String refreshIndexInterval(String indexName, String indexType, int interval) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/" + indexType + "/_settings", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
    }

    @Override
    public String refreshIndexInterval(int interval, boolean preserveExisting) throws ElasticSearchException {
        if (preserveExisting) {
            return this.client.executeHttp("_all/_settings?preserve_existing=true", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
        }
        return this.client.executeHttp("_all/_settings?preserve_existing=false", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
    }

    @Override
    public String refreshIndexInterval(int interval) throws ElasticSearchException {
        return this.refreshIndexInterval(interval, false);
    }
}

