/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.spi.remote.http.BaseResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchMapResponseHandler
extends BaseResponseHandler
implements ResponseHandler<MapRestResponse> {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchMapResponseHandler.class);

    public MapRestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    return (MapRestResponse)super.converJson(entity, MapRestResponse.class);
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            throw new ElasticSearchException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new ElasticSearchException("Unexpected response status: " + status);
    }
}

