/*
 * Decompiled with CFR 0.152.
 */
package com.chrm.mybatis.generator.plugins;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class CommentPlugin
extends PluginAdapter {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.getJavaDocLines().clear();
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" * Table: " + introspectedTable.getFullyQualifiedTable());
        topLevelClass.addJavaDocLine(" */");
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        this.comment((JavaElement)field, introspectedTable, introspectedColumn);
        return true;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return true;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return true;
    }

    private void comment(JavaElement element, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        element.getJavaDocLines().clear();
        element.addJavaDocLine("/**");
        String remark = introspectedColumn.getRemarks();
        if (remark != null && remark.length() > 1) {
            element.addJavaDocLine(" * " + remark);
            element.addJavaDocLine(" *");
        }
        element.addJavaDocLine(" * Table:     " + introspectedTable.getFullyQualifiedTable());
        element.addJavaDocLine(" * Column:    " + introspectedColumn.getActualColumnName());
        element.addJavaDocLine(" * Nullable:  " + introspectedColumn.isNullable());
        element.addJavaDocLine(" */");
    }

    public boolean sqlMapResultMapWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.commentResultMap(element, introspectedTable);
        return true;
    }

    public boolean sqlMapResultMapWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.commentResultMap(element, introspectedTable);
        return true;
    }

    void commentResultMap(XmlElement element, IntrospectedTable introspectedTable) {
        List es = element.getElements();
        if (!es.isEmpty()) {
            String alias = introspectedTable.getTableConfiguration().getAlias();
            int aliasLen = -1;
            if (alias != null) {
                aliasLen = alias.length() + 1;
            }
            Iterator it = es.iterator();
            HashMap<XmlElement, TextElement> map = new HashMap<XmlElement, TextElement>();
            while (it.hasNext()) {
                IntrospectedColumn ic;
                Element e = (Element)it.next();
                if (e instanceof TextElement) {
                    it.remove();
                    continue;
                }
                XmlElement el = (XmlElement)e;
                List as = el.getAttributes();
                if (as.isEmpty()) continue;
                String col = null;
                for (Attribute a : as) {
                    if (!a.getName().equalsIgnoreCase("column")) continue;
                    col = a.getValue();
                    break;
                }
                if (col == null) continue;
                if (aliasLen > 0) {
                    col = col.substring(aliasLen);
                }
                if ((ic = introspectedTable.getColumn(col)) == null) continue;
                StringBuilder sb = new StringBuilder();
                if (ic.getRemarks() == null || ic.getRemarks().length() <= 1) continue;
                sb.append("<!-- ");
                sb.append(ic.getRemarks());
                sb.append(" -->");
                map.put(el, new TextElement(sb.toString()));
            }
            if (map.isEmpty()) {
                return;
            }
            Set set = map.keySet();
            for (Element e : set) {
                int id = es.indexOf(e);
                es.add(id, (Element)map.get(e));
                es.add(id, new TextElement(""));
            }
            return;
        }
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeAttribute(element.getAttributes(), "parameterType");
        return true;
    }

    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeAttribute(element.getAttributes(), "parameterType");
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeAttribute(element.getAttributes(), "parameterType");
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeAttribute(element.getAttributes(), "parameterType");
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.removeAttribute(element.getAttributes(), "parameterType");
        return true;
    }

    private void removeAttribute(List<Attribute> as, String name) {
        if (!as.isEmpty()) {
            Attribute attr;
            Iterator<Attribute> it = as.iterator();
            do {
                if (it.hasNext()) continue;
                return;
            } while (!(attr = it.next()).getName().equalsIgnoreCase(name));
            it.remove();
        }
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        document.getRootElement().addElement((Element)new TextElement(""));
        document.getRootElement().addElement((Element)new TextElement("<!-- ### \u4ee5\u4e0a\u4ee3\u7801\u7531MBG + CommentPlugin\u81ea\u52a8\u751f\u6210, \u751f\u6210\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + " ### -->\n\n\n"));
        document.getRootElement().addElement((Element)new TextElement("<!-- Your codes goes here!!! -->"));
        document.getRootElement().addElement((Element)new TextElement(""));
        return true;
    }
}

