package com.coolxiaoyoa.donwload;

/**
 * @author Kerry on 18/09/29
 */

public class HttpConfig {
    private int port;
    private String basePath;
    private boolean isShowHidden;
    private int cacheSecond;

    private HttpConfig(Builder builder) {
        port = builder.port;
        basePath = builder.basePath;
        isShowHidden = builder.isShowHidden;
        cacheSecond = builder.cacheSecond;
    }

    public int getPort() {
        return port;
    }

    public String getBasePath() {
        return basePath;
    }

    public boolean isShowHidden() {
        return isShowHidden;
    }

    public int getCacheSecond() {
        return cacheSecond;
    }

    @Override
    public String toString() {
        return "HttpConfig{" +
                "port=" + port +
                ", basePath='" + basePath + '\'' +
                ", isShowHidden=" + isShowHidden +
                ", cacheSecond=" + cacheSecond +
                '}';
    }

    public static final class Builder {
        private int port = 8080;
        private String basePath = "/";
        private boolean isShowHidden = false;
        private int cacheSecond = 60;


        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder basePath(String val) {
            basePath = val;
            return this;
        }

        public Builder isShowHidden(boolean val) {
            isShowHidden = val;
            return this;
        }

        public Builder cacheSecond(int val) {
            cacheSecond = val;
            return this;
        }

        public HttpConfig build() {
            return new HttpConfig(this);
        }
    }
}
