/*
 * Decompiled with CFR 0.152.
 */
package com.coolxiaoyoa.donwload;

import com.coolxiaoyoa.donwload.HttpConfig;
import com.coolxiaoyoa.donwload.HttpDownloadServerHandler;
import com.coolxiaoyoa.donwload.MainController;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDownloadServer
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(HttpDownloadServer.class);
    private final HttpConfig httpConfig;
    private MainController mainController;

    public HttpDownloadServer(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNetty() throws IOException {
        logger.info("{}", (Object)this.httpConfig);
        File baseFolder = new File(this.httpConfig.getBasePath());
        if (!baseFolder.exists() || !baseFolder.isDirectory()) {
            throw new IOException("Base path is empty or not a folder!" + this.httpConfig.getBasePath());
        }
        this.mainController = new MainController(this.httpConfig);
        NioEventLoopGroup boss = new NioEventLoopGroup();
        NioEventLoopGroup work = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)work).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(65535));
                pipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("http-chunk", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("http-handler", (ChannelHandler)new HttpDownloadServerHandler(HttpDownloadServer.this.mainController));
            }
        });
        try {
            ChannelFuture sync = bootstrap.bind(this.httpConfig.getPort()).sync();
            sync.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            boss.shutdownGracefully();
            work.shutdownGracefully();
        }
    }

    @Override
    public void run() {
        try {
            this.startNetty();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

