/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.highlight.converter;

import com.deepoove.poi.plugin.highlight.converter.SelectorStyle;
import com.deepoove.poi.util.ResourceLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class StylesheetParser {
    private static Map<String, List<SelectorStyle>> stylesheetCache = new ConcurrentHashMap<String, List<SelectorStyle>>();

    public static List<SelectorStyle> parse(String path) throws Exception {
        List<SelectorStyle> result = stylesheetCache.get(path);
        if (null != result) {
            return result;
        }
        String css = ResourceLoader.loadContent((String)path);
        int cursor = 0;
        int length = css.length();
        ArrayList<SelectorStyle> allSelectorStyles = new ArrayList<SelectorStyle>();
        ArrayList<SelectorStyle> current = new ArrayList<SelectorStyle>();
        String currentKey = "";
        boolean ignore = false;
        String ele = "";
        while (cursor < length) {
            char character = css.charAt(cursor);
            if (ignore && character != '*' && character != '/') {
                ++cursor;
                ele = StylesheetParser.clearChar();
                continue;
            }
            switch (character) {
                case '{': {
                    String[] split;
                    String selector = ele;
                    ele = StylesheetParser.clearChar();
                    for (String select : split = selector.split(",")) {
                        current.add(new SelectorStyle(select.trim()));
                    }
                    break;
                }
                case '}': {
                    String value = ele.trim();
                    ele = StylesheetParser.clearChar();
                    if (StringUtils.isNotBlank((CharSequence)currentKey)) {
                        for (SelectorStyle cs : current) {
                            cs.getPropertyValues().put(currentKey, value);
                        }
                        currentKey = "";
                    }
                    allSelectorStyles.addAll(current);
                    ele = StylesheetParser.clearChar();
                    current = new ArrayList();
                    break;
                }
                case '/': {
                    ele = ele + character;
                    if (!ele.trim().endsWith("*/")) break;
                    ignore = false;
                    ele = StylesheetParser.clearChar();
                    break;
                }
                case '*': {
                    ele = ele + character;
                    if (!"/*".equals(ele.trim())) break;
                    ignore = true;
                    ele = StylesheetParser.clearChar();
                    break;
                }
                case ':': {
                    currentKey = ele.trim();
                    ele = StylesheetParser.clearChar();
                    break;
                }
                case ';': {
                    String value = ele.trim();
                    ele = StylesheetParser.clearChar();
                    for (SelectorStyle cs : current) {
                        cs.getPropertyValues().put(currentKey, value);
                    }
                    currentKey = "";
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    ele = ele + character;
                }
            }
            ++cursor;
        }
        stylesheetCache.put(path, allSelectorStyles);
        return allSelectorStyles;
    }

    private static String clearChar() {
        return "";
    }
}

