/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat;

import com.dianping.cat.analyzer.EventAggregator;
import com.dianping.cat.analyzer.LocalAggregator;
import com.dianping.cat.analyzer.MetricTagAggregator;
import com.dianping.cat.analyzer.TransactionAggregator;
import com.dianping.cat.configuration.ApplicationEnvironment;
import com.dianping.cat.configuration.ClientConfigProvider;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import com.dianping.cat.log.CatLogger;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultMessageManager;
import com.dianping.cat.message.internal.DefaultMessageProducer;
import com.dianping.cat.message.internal.NullMessage;
import com.dianping.cat.message.internal.NullMessageManager;
import com.dianping.cat.message.internal.NullMessageProducer;
import com.dianping.cat.message.io.TcpSocketSender;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.status.StatusUpdateTask;
import com.dianping.cat.util.Properties;
import com.dianping.cat.util.StringUtils;
import com.dianping.cat.util.Threads;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class Cat {
    private static MessageProducer producer;
    private static MessageManager manager;
    private static int errorCount;
    private static final Cat instance;
    private static volatile boolean init;
    private static volatile boolean enabled;
    private static volatile boolean JSTACK_ENABLED;
    private static volatile boolean MULTI_INSTANCES;
    private static volatile boolean DATASOURCE_MONITOR_ENABLED;
    public static final String CLIENT_CONFIG = "cat-client-config";
    public static final String UNKNOWN = "unknown";

    public static boolean isJstackEnabled() {
        String enable = Properties.forString().fromEnv().fromSystem().getProperty("jstack_enable", "true");
        return JSTACK_ENABLED && Boolean.valueOf(enable) != false;
    }

    private static void checkAndInitialize() {
        try {
            if (!init) {
                ClientConfig clientConfig = Cat.getSpiClientConfig();
                if (clientConfig == null) {
                    Cat.initializeInternal();
                } else {
                    Cat.initializeInternal(clientConfig);
                }
            }
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    private static ClientConfig getSpiClientConfig() {
        ServiceLoader<ClientConfigProvider> clientConfigProviders = ServiceLoader.load(ClientConfigProvider.class);
        if (clientConfigProviders == null) {
            return null;
        }
        Iterator<ClientConfigProvider> iterator = clientConfigProviders.iterator();
        if (iterator.hasNext()) {
            ClientConfigProvider clientConfigProvider = iterator.next();
            return clientConfigProvider.getClientConfig();
        }
        return null;
    }

    public static String createMessageId() {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().createMessageId();
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
            }
        }
        return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public static void disableDataSourceMonitor() {
        DATASOURCE_MONITOR_ENABLED = false;
    }

    public static void disableJstack() {
        JSTACK_ENABLED = false;
    }

    public static void disableMultiInstances() {
        MULTI_INSTANCES = false;
    }

    public static void enableMultiInstances() {
        MULTI_INSTANCES = true;
    }

    private static void errorHandler(Exception e) {
        if (Cat.isEnabled() && errorCount < 3) {
            ++errorCount;
            CatLogger.getInstance().error(e.getMessage(), e);
        }
    }

    public static String getCatHome() {
        return Properties.forString().fromEnv().fromSystem().getProperty("CAT_HOME", "/data/appdatas/cat/");
    }

    public static String getCurrentMessageId() {
        if (Cat.isEnabled()) {
            try {
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                if (tree != null) {
                    String messageId = tree.getMessageId();
                    if (messageId == null) {
                        messageId = Cat.getProducer().createMessageId();
                        tree.setMessageId(messageId);
                    }
                    return messageId;
                }
                return null;
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
            }
        }
        return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
    }

    private static String getCustomDomain() {
        String config = System.getProperty(CLIENT_CONFIG);
        if (StringUtils.isNotEmpty(config)) {
            try {
                ClientConfig clientConfig = DefaultSaxParser.parse(config);
                return clientConfig.getDomain();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Cat getInstance() {
        return instance;
    }

    public static MessageManager getManager() {
        try {
            Cat.checkAndInitialize();
            if (manager != null) {
                return manager;
            }
            return NullMessageManager.NULL_MESSAGE_MANAGER;
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessageManager.NULL_MESSAGE_MANAGER;
        }
    }

    public static MessageProducer getProducer() {
        try {
            Cat.checkAndInitialize();
            if (producer != null) {
                return producer;
            }
            return NullMessageProducer.NULL_MESSAGE_PRODUCER;
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessageProducer.NULL_MESSAGE_PRODUCER;
        }
    }

    public static void initialize() {
        Cat.checkAndInitialize();
    }

    public static void initialize(String ... servers) {
        if (Cat.isEnabled() && !init) {
            try {
                ClientConfig config = new ClientConfig();
                for (String server : servers) {
                    config.addServer(new Server(server));
                }
                String domain = ApplicationEnvironment.loadAppName(UNKNOWN);
                config.setDomain(domain);
                Cat.initializeInternal(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomain(String domain) {
        if (Cat.isEnabled() && !init) {
            try {
                String domainName = ApplicationEnvironment.loadAppName(domain);
                ClientConfig config = ApplicationEnvironment.loadClientConfig(domainName);
                Cat.initializeInternal(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomain(String domain, int port, int httpPort, String ... servers) {
        if (Cat.isEnabled() && !init) {
            try {
                ClientConfig config = new ClientConfig();
                config.setDomain(ApplicationEnvironment.loadAppName(domain));
                for (String server : servers) {
                    Server serverObj = new Server(server);
                    serverObj.setHttpPort(httpPort);
                    serverObj.setPort(port);
                    config.addServer(serverObj);
                }
                Cat.initializeInternal(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomain(String domain, String ... servers) {
        if (Cat.isEnabled() && !init) {
            try {
                Cat.initializeByDomain(domain, 2280, 8080, servers);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomainForce(String domain) {
        if (Cat.isEnabled() && !init) {
            try {
                ClientConfig config = ApplicationEnvironment.loadClientConfig(domain);
                Cat.initializeInternal(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeInternal() {
        block7: {
            Cat.validate();
            if (Cat.isEnabled()) {
                try {
                    if (init) break block7;
                    Cat cat = instance;
                    synchronized (cat) {
                        if (!init) {
                            producer = DefaultMessageProducer.getInstance();
                            manager = DefaultMessageManager.getInstance();
                            StatusUpdateTask heartbeatTask = new StatusUpdateTask();
                            TcpSocketSender messageSender = TcpSocketSender.getInstance();
                            Threads.forGroup("cat").start(heartbeatTask);
                            Threads.forGroup("cat").start(messageSender);
                            Threads.forGroup("cat").start(new LocalAggregator.DataUploader());
                            CatLogger.getInstance().info("Cat is lazy initialized!");
                            init = true;
                        }
                    }
                }
                catch (Exception e) {
                    Cat.errorHandler(e);
                    Cat.disable();
                }
            }
        }
    }

    private static void initializeInternal(ClientConfig config) {
        if (Cat.isEnabled()) {
            System.setProperty(CLIENT_CONFIG, config.toString());
            CatLogger.getInstance().info("init cat with config:" + config.toString());
            Cat.initializeInternal();
        }
    }

    public static boolean isDataSourceMonitorEnabled() {
        return DATASOURCE_MONITOR_ENABLED;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isInitialized() {
        return init;
    }

    public static boolean isMultiInstanceEnable() {
        return MULTI_INSTANCES;
    }

    public static void logBatchEvent(String type, String name, int count, int error) {
        if (Cat.isEnabled()) {
            try {
                EventAggregator.getInstance().logBatchEvent(type, name, count, error);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logBatchTransaction(String type, String name, int count, int error, long sum) {
        if (Cat.isEnabled()) {
            TransactionAggregator.getInstance().logBatchTransaction(type, name, count, error, sum);
        }
    }

    public static void logError(String message, Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logError(message, cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logError(Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logError(cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logErrorWithCategory(String category, String message, Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logErrorWithCategory(category, message, cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logErrorWithCategory(String category, Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logErrorWithCategory(category, cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logEvent(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logEvent(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logEvent(String type, String name, String status, String nameValuePairs) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logEvent(type, name, status, nameValuePairs);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForCount(String name) {
        Cat.logMetricForCount(name, null);
    }

    public static void logMetricForCount(String name, int quantity) {
        Cat.logMetricForCount(name, quantity, null);
    }

    public static void logMetricForCount(String name, int quantity, Map<String, String> tags) {
        if (Cat.isEnabled()) {
            Cat.checkAndInitialize();
            try {
                MetricTagAggregator.getInstance().addCountMetric(name, quantity, tags);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForCount(String name, Map<String, String> tags) {
        if (Cat.isEnabled()) {
            Cat.checkAndInitialize();
            try {
                MetricTagAggregator.getInstance().addCountMetric(name, 1, tags);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForDuration(String name, long durationInMillis) {
        Cat.logMetricForDuration(name, durationInMillis, null);
    }

    public static void logMetricForDuration(String name, long durationInMillis, Map<String, String> tags) {
        if (Cat.isEnabled()) {
            Cat.checkAndInitialize();
            try {
                MetricTagAggregator.getInstance().addTimerMetric(name, durationInMillis, tags);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logRemoteCallClient(Context ctx) {
        if (Cat.isEnabled()) {
            try {
                Cat.logRemoteCallClient(ctx, "default");
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logRemoteCallClient(Context ctx, String domain) {
        if (Cat.isEnabled()) {
            try {
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                String messageId = tree.getMessageId();
                if (messageId == null) {
                    messageId = Cat.getProducer().createMessageId();
                    tree.setMessageId(messageId);
                }
                String childId = Cat.getProducer().createRpcServerId(domain);
                Cat.logEvent("RemoteCall", "", "0", childId);
                String root = tree.getRootMessageId();
                if (root == null) {
                    root = messageId;
                }
                ctx.addProperty("_catRootMessageId", root);
                ctx.addProperty("_catParentMessageId", messageId);
                ctx.addProperty("_catChildMessageId", childId);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logRemoteCallServer(Context ctx) {
        if (Cat.isEnabled()) {
            try {
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                String childId = ctx.getProperty("_catChildMessageId");
                String rootId = ctx.getProperty("_catRootMessageId");
                String parentId = ctx.getProperty("_catParentMessageId");
                if (parentId != null) {
                    tree.setParentMessageId(parentId);
                }
                if (rootId != null) {
                    tree.setRootMessageId(rootId);
                }
                if (childId != null) {
                    tree.setMessageId(childId);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newCompletedTransactionWithDuration(String type, String name, long duration) {
        if (Cat.isEnabled()) {
            try {
                Transaction transaction = Cat.getProducer().newTransaction(type, name);
                try {
                    transaction.setDurationInMillis(duration);
                    if (duration > 0L && duration < 60000L) {
                        transaction.setTimestamp(System.currentTimeMillis() - duration);
                    }
                    transaction.setStatus("0");
                }
                catch (Exception e) {
                    transaction.setStatus(e);
                }
                finally {
                    transaction.complete();
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static Event newEvent(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().newEvent(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.EVENT;
            }
        }
        return NullMessage.EVENT;
    }

    public static Trace newTrace(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().newTrace(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.TRACE;
            }
        }
        return NullMessage.TRACE;
    }

    public static Transaction newTransaction(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().newTransaction(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.TRANSACTION;
            }
        }
        return NullMessage.TRANSACTION;
    }

    public static Transaction newTransactionWithDuration(String type, String name, long duration) {
        if (Cat.isEnabled()) {
            try {
                Transaction transaction = Cat.getProducer().newTransaction(type, name);
                transaction.setDurationInMillis(duration);
                if (duration < 60000L) {
                    transaction.setTimestamp(System.currentTimeMillis() - duration);
                }
                return transaction;
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.TRANSACTION;
            }
        }
        return NullMessage.TRANSACTION;
    }

    private static void validate() {
        String enable = Properties.forString().fromEnv().fromSystem().getProperty("CAT_ENABLED", "true");
        if ("false".equals(enable)) {
            CatLogger.getInstance().info("CAT is disable due to system environment CAT_ENABLED is false.");
            enabled = false;
        } else {
            String customDomain = Cat.getCustomDomain();
            if (customDomain == null && UNKNOWN.equals(ApplicationEnvironment.loadAppName(UNKNOWN))) {
                CatLogger.getInstance().info("CAT is disable due to no app name in resource file /META-INF/app.properties");
                enabled = false;
            }
        }
    }

    private Cat() {
    }

    static {
        instance = new Cat();
        init = false;
        enabled = true;
        JSTACK_ENABLED = true;
        MULTI_INSTANCES = false;
        DATASOURCE_MONITOR_ENABLED = true;
    }

    public static interface Context {
        public static final String ROOT = "_catRootMessageId";
        public static final String PARENT = "_catParentMessageId";
        public static final String CHILD = "_catChildMessageId";
        public static final String DISCARD = "_catDiscard";

        public void addProperty(String var1, String var2);

        public String getProperty(String var1);
    }
}

