/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.entity;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultXmlBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClientConfig
extends BaseEntity<ClientConfig> {
    private String mode;
    private boolean enabled = true;
    private Boolean dumpLocked;
    private List<Server> servers = new ArrayList<Server>();
    private Map<String, Domain> domains = new LinkedHashMap<String, Domain>();
    private Bind bind;
    private List<Property> properties = new ArrayList<Property>();
    private String domain = "unknown";
    private int maxMessageSize = 5000;

    public ClientConfig() {
    }

    public ClientConfig(String domain) {
        if (domain != null) {
            this.domain = domain;
        }
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitConfig(this);
    }

    public ClientConfig addDomain(Domain domain) {
        this.domains.put(domain.getId(), domain);
        return this;
    }

    public ClientConfig addProperty(Property property) {
        this.properties.add(property);
        return this;
    }

    public ClientConfig addServer(Server server) {
        this.servers.add(server);
        return this;
    }

    public Domain findDomain(String id) {
        return this.domains.get(id);
    }

    public Server findServer(String ip) {
        for (Server server : this.servers) {
            if (!server.getIp().equals(ip)) continue;
            return server;
        }
        return null;
    }

    @Override
    public void mergeAttributes(ClientConfig other) {
        this.assertAttributeEquals(other, "config", "domain", this.domain, other.getDomain());
        if (other.getMode() != null) {
            this.mode = other.getMode();
        }
        this.enabled = other.isEnabled();
        if (other.getDumpLocked() != null) {
            this.dumpLocked = other.getDumpLocked();
        }
        this.maxMessageSize = other.getMaxMessageSize();
    }

    public boolean removeDomain(String id) {
        if (this.domains.containsKey(id)) {
            this.domains.remove(id);
            return true;
        }
        return false;
    }

    public boolean removeServer(String ip) {
        int len = this.servers.size();
        for (int i = 0; i < len; ++i) {
            Server server = this.servers.get(i);
            if (!server.getIp().equals(ip)) continue;
            this.servers.remove(i);
            return true;
        }
        return false;
    }

    public ClientConfig setBind(Bind bind) {
        this.bind = bind;
        return this;
    }

    public ClientConfig setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public ClientConfig setDumpLocked(Boolean dumpLocked) {
        this.dumpLocked = dumpLocked;
        return this;
    }

    public ClientConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ClientConfig setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public ClientConfig setMode(String mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public String toString() {
        return new DefaultXmlBuilder().buildXml(this);
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Boolean getDumpLocked() {
        return this.dumpLocked;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public Map<String, Domain> getDomains() {
        return this.domains;
    }

    public Bind getBind() {
        return this.bind;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public void setDomains(Map<String, Domain> domains) {
        this.domains = domains;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Boolean this$dumpLocked = this.getDumpLocked();
        Boolean other$dumpLocked = other.getDumpLocked();
        if (this$dumpLocked == null ? other$dumpLocked != null : !((Object)this$dumpLocked).equals(other$dumpLocked)) {
            return false;
        }
        List<Server> this$servers = this.getServers();
        List<Server> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        Map<String, Domain> this$domains = this.getDomains();
        Map<String, Domain> other$domains = other.getDomains();
        if (this$domains == null ? other$domains != null : !((Object)this$domains).equals(other$domains)) {
            return false;
        }
        Bind this$bind = this.getBind();
        Bind other$bind = other.getBind();
        if (this$bind == null ? other$bind != null : !((Object)this$bind).equals(other$bind)) {
            return false;
        }
        List<Property> this$properties = this.getProperties();
        List<Property> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        return this.getMaxMessageSize() == other.getMaxMessageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Boolean $dumpLocked = this.getDumpLocked();
        result = result * 59 + ($dumpLocked == null ? 43 : ((Object)$dumpLocked).hashCode());
        List<Server> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        Map<String, Domain> $domains = this.getDomains();
        result = result * 59 + ($domains == null ? 43 : ((Object)$domains).hashCode());
        Bind $bind = this.getBind();
        result = result * 59 + ($bind == null ? 43 : ((Object)$bind).hashCode());
        List<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        result = result * 59 + this.getMaxMessageSize();
        return result;
    }
}

