/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.entity;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IVisitor;

public class Domain
extends BaseEntity<Domain> {
    private String id;
    private String ip;
    private boolean enabled = true;
    private int maxMessageSize = 1000;

    public Domain() {
    }

    public Domain(String id) {
        this.id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    @Override
    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals(other, "domain", "id", this.id, other.getId());
        if (other.getIp() != null) {
            this.ip = other.getIp();
        }
        this.enabled = other.isEnabled();
        this.maxMessageSize = other.getMaxMessageSize();
    }

    public Domain setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Domain setId(String id) {
        this.id = id;
        return this;
    }

    public Domain setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public Domain setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public String toString() {
        return "Domain(id=" + this.getId() + ", ip=" + this.getIp() + ", enabled=" + this.isEnabled() + ", maxMessageSize=" + this.getMaxMessageSize() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        return this.getMaxMessageSize() == other.getMaxMessageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Domain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxMessageSize();
        return result;
    }
}

