/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.entity;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IVisitor;

public class Server
extends BaseEntity<Server> {
    private String ip;
    private int port = 2280;
    private int httpPort = 8080;
    private boolean enabled = true;

    public Server() {
    }

    public Server(String ip) {
        this.ip = ip;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitServer(this);
    }

    @Override
    public void mergeAttributes(Server other) {
        this.assertAttributeEquals(other, "server", "ip", this.ip, other.getIp());
        this.port = other.getPort();
        this.httpPort = other.getHttpPort();
        this.enabled = other.isEnabled();
    }

    public Server setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Server setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public Server setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public Server setPort(int port) {
        this.port = port;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String toString() {
        return "Server(ip=" + this.getIp() + ", port=" + this.getPort() + ", httpPort=" + this.getHttpPort() + ", enabled=" + this.isEnabled() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getHttpPort() != other.getHttpPort()) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getHttpPort();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }
}

