/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.transform;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IEntity;
import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> objects = new Stack();
    private ClientConfig config;

    public DefaultMerger() {
    }

    public DefaultMerger(ClientConfig config) {
        this.config = config;
        this.objects.push(config);
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    protected Stack<Object> getObjects() {
        return this.objects;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.objects.push(to);
        from.accept(this);
        this.objects.pop();
    }

    protected void mergeBind(Bind to, Bind from) {
        to.mergeAttributes(from);
    }

    protected void mergeConfig(ClientConfig to, ClientConfig from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeProperty(Property to, Property from) {
        to.mergeAttributes(from);
        to.setText(from.getText());
    }

    protected void mergeServer(Server to, Server from) {
        to.mergeAttributes(from);
    }

    @Override
    public void visitBind(Bind from) {
        Bind to = (Bind)this.objects.peek();
        this.mergeBind(to, from);
        this.visitBindChildren(to, from);
    }

    protected void visitBindChildren(Bind to, Bind from) {
    }

    @Override
    public void visitConfig(ClientConfig from) {
        ClientConfig to = (ClientConfig)this.objects.peek();
        this.mergeConfig(to, from);
        this.visitConfigChildren(to, from);
    }

    protected void visitConfigChildren(ClientConfig to, ClientConfig from) {
        BaseEntity target;
        for (Server server : from.getServers()) {
            target = to.findServer(server.getIp());
            if (target == null) {
                target = new Server(server.getIp());
                to.addServer((Server)target);
            }
            this.objects.push(target);
            server.accept(this);
            this.objects.pop();
        }
        for (Domain domain : from.getDomains().values()) {
            target = to.findDomain(domain.getId());
            if (target == null) {
                target = new Domain(domain.getId());
                to.addDomain((Domain)target);
            }
            this.objects.push(target);
            domain.accept(this);
            this.objects.pop();
        }
        if (from.getBind() != null) {
            Bind target2 = to.getBind();
            if (target2 == null) {
                target2 = new Bind();
                to.setBind(target2);
            }
            this.objects.push(target2);
            from.getBind().accept(this);
            this.objects.pop();
        }
        for (Property property : from.getProperties()) {
            target = null;
            if (target == null) {
                target = new Property();
                to.addProperty((Property)target);
            }
            this.objects.push(target);
            property.accept(this);
            this.objects.pop();
        }
    }

    @Override
    public void visitDomain(Domain from) {
        Domain to = (Domain)this.objects.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
    }

    @Override
    public void visitProperty(Property from) {
        Property to = (Property)this.objects.peek();
        this.mergeProperty(to, from);
        this.visitPropertyChildren(to, from);
    }

    protected void visitPropertyChildren(Property to, Property from) {
    }

    @Override
    public void visitServer(Server from) {
        Server to = (Server)this.objects.peek();
        this.mergeServer(to, from);
        this.visitServerChildren(to, from);
    }

    protected void visitServerChildren(Server to, Server from) {
    }
}

