/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.transform;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IEntity;
import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import java.util.Map;

public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor visitor = this;
    private int level;
    private StringBuilder sb;
    private boolean compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.compact = compact;
        this.sb = sb;
        this.sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.visitor);
        return this.sb.toString();
    }

    private void endTag(String name) {
        --this.level;
        this.indent();
        this.sb.append("</").append(name).append(">\r\n");
    }

    private String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private void indent() {
        if (!this.compact) {
            for (int i = this.level - 1; i >= 0; --i) {
                this.sb.append("   ");
            }
        }
    }

    private void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    private void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, closed, dynamicAttributes, nameValues);
    }

    private void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, false, dynamicAttributes, nameValues);
    }

    private void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.sb.append('>');
            this.sb.append(this.escape(text, true));
            this.sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.sb.append('/');
            } else {
                ++this.level;
            }
            this.sb.append(">\r\n");
        }
    }

    @Override
    public void visitBind(Bind bind) {
        this.startTag("bind", true, null, "ip", bind.getIp(), "port", bind.getPort());
    }

    @Override
    public void visitConfig(ClientConfig config) {
        this.startTag("config", null, "mode", config.getMode(), "enabled", config.isEnabled(), "dump-locked", config.getDumpLocked(), "domain", config.getDomain(), "max-message-size", config.getMaxMessageSize());
        if (!config.getServers().isEmpty()) {
            this.startTag("servers");
            for (BaseEntity baseEntity : config.getServers().toArray(new Server[0])) {
                ((Server)baseEntity).accept(this.visitor);
            }
            this.endTag("servers");
        }
        if (!config.getDomains().isEmpty()) {
            for (BaseEntity baseEntity : config.getDomains().values().toArray(new Domain[0])) {
                ((Domain)baseEntity).accept(this.visitor);
            }
        }
        if (config.getBind() != null) {
            config.getBind().accept(this.visitor);
        }
        if (!config.getProperties().isEmpty()) {
            this.startTag("properties");
            for (BaseEntity baseEntity : config.getProperties().toArray(new Property[0])) {
                ((Property)baseEntity).accept(this.visitor);
            }
            this.endTag("properties");
        }
        this.endTag("config");
    }

    @Override
    public void visitDomain(Domain domain) {
        this.startTag("domain", true, null, "id", domain.getId(), "ip", domain.getIp(), "enabled", domain.isEnabled(), "max-message-size", domain.getMaxMessageSize());
    }

    @Override
    public void visitProperty(Property property) {
        this.startTag("property", property.getText(), true, null, "name", property.getName());
    }

    @Override
    public void visitServer(Server server) {
        this.startTag("server", true, null, "ip", server.getIp(), "port", server.getPort(), "http-port", server.getHttpPort(), "enabled", server.isEnabled());
    }
}

