/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.property.entity;

import com.dianping.cat.configuration.property.BaseEntity;
import com.dianping.cat.configuration.property.IVisitor;
import com.dianping.cat.configuration.property.entity.Property;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyConfig
extends BaseEntity<PropertyConfig> {
    private Map<String, Property> properties = new LinkedHashMap<String, Property>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitPropertyConfig(this);
    }

    public PropertyConfig addProperty(Property property) {
        this.properties.put(property.getId(), property);
        return this;
    }

    public Property findProperty(String id) {
        return this.properties.get(id);
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void mergeAttributes(PropertyConfig other) {
    }

    public boolean removeProperty(String id) {
        if (this.properties.containsKey(id)) {
            this.properties.remove(id);
            return true;
        }
        return false;
    }

    public void setProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    @Override
    public String toString() {
        return "PropertyConfig(properties=" + this.getProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyConfig)) {
            return false;
        }
        PropertyConfig other = (PropertyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Property> this$properties = this.getProperties();
        Map<String, Property> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

