/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.property.transform;

import com.dianping.cat.configuration.property.IEntity;
import com.dianping.cat.configuration.property.entity.Property;
import com.dianping.cat.configuration.property.entity.PropertyConfig;
import com.dianping.cat.configuration.property.transform.DefaultLinker;
import com.dianping.cat.configuration.property.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker linker = new DefaultLinker(true);
    private DefaultSaxMaker maker = new DefaultSaxMaker();
    private Stack<String> tags = new Stack();
    private Stack<Object> objects = new Stack();
    private IEntity<?> entity;
    private StringBuilder text = new StringBuilder();

    public static PropertyConfig parse(InputSource is) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(PropertyConfig.class, is);
    }

    public static PropertyConfig parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(in));
    }

    public static PropertyConfig parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(reader));
    }

    public static PropertyConfig parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.objects.pop();
            this.tags.pop();
        }
        this.text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.entity;
    }

    protected String getText() {
        return this.text.toString();
    }

    private void parseForProperty(Property parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForPropertyConfig(PropertyConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"property".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under property-config!", qName));
        }
        Property property = this.maker.buildProperty(attributes);
        this.linker.onProperty(parentObj, property);
        this.objects.push(property);
        this.tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("property-config".equals(qName)) {
            PropertyConfig propertyConfig;
            this.entity = propertyConfig = this.maker.buildPropertyConfig(attributes);
            this.objects.push(propertyConfig);
            this.tags.push(qName);
        } else if ("property".equals(qName)) {
            Property property;
            this.entity = property = this.maker.buildProperty(attributes);
            this.objects.push(property);
            this.tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.objects.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.objects.peek();
            String tag = this.tags.peek();
            if (parent instanceof PropertyConfig) {
                this.parseForPropertyConfig((PropertyConfig)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Property)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForProperty((Property)parent, tag, qName, attributes);
            }
        }
        this.text.setLength(0);
    }
}

