/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.internal.shaded.io.netty.buffer.ByteBuf;
import com.dianping.cat.internal.shaded.io.netty.buffer.ByteBufAllocator;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.io.BufReleaseHelper;
import com.dianping.cat.message.spi.codec.PlainTextMessageCodec;
import java.nio.charset.Charset;

public abstract class AbstractMessage
implements Message {
    protected String type;
    private String name;
    private String status = "0";
    private int statusCode = 1;
    private long timestampInMillis;
    private CharSequence data;
    private boolean completed;

    AbstractMessage(String type, String name) {
        this.type = String.valueOf(type);
        this.name = String.valueOf(name);
        this.timestampInMillis = System.currentTimeMillis();
    }

    public void setData(String str) {
        this.data = str;
    }

    @Override
    public void addData(String keyValuePairs) {
        if (this.data == null) {
            this.data = keyValuePairs;
        } else if (this.data instanceof StringBuilder) {
            ((StringBuilder)this.data).append('&').append(keyValuePairs);
        } else {
            StringBuilder sb = new StringBuilder(this.data.length() + keyValuePairs.length() + 16);
            sb.append(this.data).append('&');
            sb.append(keyValuePairs);
            this.data = sb;
        }
    }

    @Override
    public void addData(String key, Object value) {
        if (this.data instanceof StringBuilder) {
            ((StringBuilder)this.data).append('&').append(key).append('=').append(value);
        } else {
            String str = String.valueOf(value);
            int old = this.data == null ? 0 : this.data.length();
            StringBuilder sb = new StringBuilder(old + key.length() + str.length() + 16);
            if (this.data != null) {
                sb.append(this.data).append('&');
            }
            sb.append(key).append('=').append(str);
            this.data = sb;
        }
    }

    @Override
    public CharSequence getData() {
        if (this.data == null) {
            return "";
        }
        return this.data;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public long getTimestamp() {
        return this.timestampInMillis;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isSuccess() {
        return this.statusCode > 0;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
        this.statusCode = "0".equals(this.status) ? 1 : -1;
    }

    @Override
    public void setStatus(Throwable e) {
        this.status = e.getClass().getName();
        this.statusCode = -1;
    }

    @Override
    public void setSuccessStatus() {
        this.status = "0";
        this.statusCode = 1;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestampInMillis = timestamp;
    }

    public void setType(String type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            codec.encodeMessage(this, buf);
            codec.reset();
            String string = buf.toString(Charset.forName("utf-8"));
            return string;
        }
        finally {
            BufReleaseHelper.release(buf);
        }
    }
}

