/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.ForkableTransaction;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultForkedTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultForkableTransaction
extends AbstractMessage
implements ForkableTransaction {
    private String rootMessageId;
    private String parentMessageId;
    private long durationInMicros;
    private List<Message> children = Collections.synchronizedList(new ArrayList());

    private static String generateThreadName() {
        int index;
        String threadName = Thread.currentThread().getName();
        if (threadName.startsWith("qtp") && (index = threadName.indexOf(" ")) > -1) {
            threadName = threadName.substring(0, index);
        }
        if (threadName.length() > 80) {
            threadName = "ThreadID-" + String.valueOf(Thread.currentThread().getId());
        }
        return threadName;
    }

    public DefaultForkableTransaction(String rootMessageId, String parentMessageId) {
        super("System", "Forkable");
        this.rootMessageId = rootMessageId;
        this.parentMessageId = parentMessageId;
        this.durationInMicros = System.nanoTime() / 1000L;
        this.setStatus("0");
        this.addData("thread-name=" + DefaultForkableTransaction.generateThreadName());
    }

    @Override
    public Transaction addChild(Message message) {
        this.children.add(message);
        return this;
    }

    @Override
    public synchronized void complete() {
        if (!this.isCompleted()) {
            super.setCompleted(true);
            this.durationInMicros = 0L;
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                Message child = this.children.get(i);
                ForkedTransaction forked = (ForkedTransaction)child;
                this.children.set(i, forked.join());
            }
        }
    }

    @Override
    public synchronized ForkedTransaction doFork() {
        DefaultForkedTransaction child = new DefaultForkedTransaction(this.rootMessageId, this.parentMessageId);
        if (this.isCompleted()) {
            this.children.add(child.join());
        } else {
            this.children.add(child);
        }
        Cat.getManager().getContext().attach(child, this.rootMessageId, this.parentMessageId);
        return child;
    }

    @Override
    public ForkableTransaction forFork() {
        return this;
    }

    @Override
    public List<Message> getChildren() {
        return this.children;
    }

    @Override
    public long getDurationInMicros() {
        if (super.isCompleted()) {
            return this.durationInMicros;
        }
        return 0L;
    }

    @Override
    public long getDurationInMillis() {
        if (super.isCompleted()) {
            return this.durationInMicros / 1000L;
        }
        return 0L;
    }

    @Override
    public long getRawDurationInMicros() {
        return this.durationInMicros;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public void setDurationInMicros(long durationInMicros) {
        this.durationInMicros = durationInMicros;
    }

    @Override
    public void setDurationInMillis(long durationInMillis) {
        this.durationInMicros = durationInMillis * 1000L;
    }

    @Override
    public void setDurationStart(long durationStart) {
        throw new UnsupportedOperationException();
    }
}

