/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.codec;

import com.dianping.cat.Cat;
import com.dianping.cat.internal.shaded.io.netty.buffer.ByteBuf;
import com.dianping.cat.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultHeartbeat;
import com.dianping.cat.message.internal.DefaultMetric;
import com.dianping.cat.message.internal.DefaultTrace;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.io.BufReleaseHelper;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.codec.BufferWriter;
import com.dianping.cat.message.spi.codec.EscapingBufferWriter;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class PlainTextMessageCodec
implements MessageCodec {
    private static final String VERSION = "PT1";
    private static final byte TAB = 9;
    private static final byte LF = 10;
    private BufferWriter writer = new EscapingBufferWriter();
    private BufferHelper bufferHelper = new BufferHelper(this.writer);
    private DateHelper dateHelper = new DateHelper();
    private ThreadLocal<Context> ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeTree(MessageTree tree) {
        String result = "";
        ByteBuf buf = null;
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = codec.encode(tree);
            buf.readInt();
            result = buf.toString(Charset.forName("utf-8"));
            BufReleaseHelper.release(buf);
        }
        catch (Exception ex) {
            Cat.logError(ex);
        }
        finally {
            BufReleaseHelper.release(buf);
        }
        return result;
    }

    @Override
    public MessageTree decode(ByteBuf buf) {
        buf.readInt();
        DefaultMessageTree tree = new DefaultMessageTree();
        this.decode(buf, tree);
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(ByteBuf buf, MessageTree tree) {
        if (this.ctx == null) {
            this.ctx = new ThreadLocal<Context>(){

                @Override
                protected Context initialValue() {
                    return new Context();
                }
            };
        }
        Context ctx = this.ctx.get().setBuffer(buf);
        try {
            this.decodeHeader(ctx, tree);
            if (buf.readableBytes() > 0) {
                this.decodeMessage(ctx, tree);
            }
        }
        finally {
            ctx.removeBuf();
        }
    }

    private void decodeHeader(Context ctx, MessageTree tree) {
        BufferHelper helper = this.bufferHelper;
        String id = helper.read(ctx, (byte)9);
        String domain = helper.read(ctx, (byte)9);
        String hostName = helper.read(ctx, (byte)9);
        String ipAddress = helper.read(ctx, (byte)9);
        String threadGroupName = helper.read(ctx, (byte)9);
        String threadId = helper.read(ctx, (byte)9);
        String threadName = helper.read(ctx, (byte)9);
        String messageId = helper.read(ctx, (byte)9);
        String parentMessageId = helper.read(ctx, (byte)9);
        String rootMessageId = helper.read(ctx, (byte)9);
        String sessionToken = helper.read(ctx, (byte)10);
        if (!VERSION.equals(id)) {
            throw new RuntimeException(String.format("Unrecognized id(%s) for plain text message codec!", id));
        }
        tree.setDomain(domain);
        tree.setHostName(hostName);
        tree.setIpAddress(ipAddress);
        tree.setThreadGroupName(threadGroupName);
        tree.setThreadId(threadId);
        tree.setThreadName(threadName);
        tree.setMessageId(messageId);
        tree.setParentMessageId(parentMessageId);
        tree.setRootMessageId(rootMessageId);
        tree.setSessionToken(sessionToken);
    }

    private Message decodeLine(Context ctx, DefaultTransaction parent, Stack<DefaultTransaction> stack, MessageTree tree) {
        BufferHelper helper = this.bufferHelper;
        byte identifier = ctx.getBuffer().readByte();
        String timestamp = helper.read(ctx, (byte)9);
        String type = helper.read(ctx, (byte)9);
        String name = helper.read(ctx, (byte)9);
        switch (identifier) {
            case 116: {
                DefaultTransaction transaction = new DefaultTransaction(type, name);
                tree.findOrCreateTransactions().add(transaction);
                helper.read(ctx, (byte)10);
                transaction.setTimestamp(this.dateHelper.parse(timestamp));
                if (parent != null) {
                    parent.addChild(transaction);
                }
                stack.push(parent);
                return transaction;
            }
            case 65: {
                DefaultTransaction tran = new DefaultTransaction(type, name);
                tree.findOrCreateTransactions().add(tran);
                String status = helper.read(ctx, (byte)9);
                String duration = helper.read(ctx, (byte)9);
                String data = helper.read(ctx, (byte)9);
                helper.read(ctx, (byte)10);
                tran.setTimestamp(this.dateHelper.parse(timestamp));
                tran.setStatus(status);
                tran.addData(data);
                long d = Long.parseLong(duration.substring(0, duration.length() - 2));
                tran.setDurationInMicros(d);
                if (parent != null) {
                    parent.addChild(tran);
                    return parent;
                }
                return tran;
            }
            case 84: {
                String transactionStatus = helper.read(ctx, (byte)9);
                String transactionDuration = helper.read(ctx, (byte)9);
                String transactionData = helper.read(ctx, (byte)9);
                helper.read(ctx, (byte)10);
                parent.setStatus(transactionStatus);
                parent.addData(transactionData);
                long transactionD = Long.parseLong(transactionDuration.substring(0, transactionDuration.length() - 2));
                parent.setDurationInMicros(transactionD);
                return stack.pop();
            }
            case 69: {
                DefaultEvent event = new DefaultEvent(type, name);
                String eventStatus = helper.read(ctx, (byte)9);
                String eventData = helper.read(ctx, (byte)9);
                helper.read(ctx, (byte)10);
                event.setTimestamp(this.dateHelper.parse(timestamp));
                event.setStatus(eventStatus);
                event.addData(eventData);
                tree.findOrCreateEvents().add(event);
                if (parent != null) {
                    parent.addChild(event);
                    return parent;
                }
                return event;
            }
            case 77: {
                DefaultMetric metric = new DefaultMetric(type, name);
                tree.findOrCreateMetrics().add(metric);
                String metricStatus = helper.read(ctx, (byte)9);
                String metricData = helper.read(ctx, (byte)9);
                helper.read(ctx, (byte)10);
                metric.setTimestamp(this.dateHelper.parse(timestamp));
                metric.setStatus(metricStatus);
                metric.addData(metricData);
                if (parent != null) {
                    parent.addChild(metric);
                    return parent;
                }
                return metric;
            }
            case 76: {
                DefaultTrace trace = new DefaultTrace(type, name);
                String traceStatus = helper.read(ctx, (byte)9);
                String traceData = helper.read(ctx, (byte)9);
                helper.read(ctx, (byte)10);
                trace.setTimestamp(this.dateHelper.parse(timestamp));
                trace.setStatus(traceStatus);
                trace.addData(traceData);
                if (parent != null) {
                    parent.addChild(trace);
                    return parent;
                }
                return trace;
            }
            case 72: {
                DefaultHeartbeat heartbeat = new DefaultHeartbeat(type, name);
                tree.findOrCreateHeartbeats().add(heartbeat);
                String heartbeatStatus = helper.read(ctx, (byte)9);
                String heartbeatData = helper.read(ctx, (byte)9);
                helper.read(ctx, (byte)10);
                heartbeat.setTimestamp(this.dateHelper.parse(timestamp));
                heartbeat.setStatus(heartbeatStatus);
                heartbeat.addData(heartbeatData);
                if (parent != null) {
                    parent.addChild(heartbeat);
                    return parent;
                }
                return heartbeat;
            }
        }
        throw new RuntimeException("Unknown identifier int name");
    }

    private void decodeMessage(Context ctx, MessageTree tree) {
        Message message;
        Stack<DefaultTransaction> stack = new Stack<DefaultTransaction>();
        Message parent = this.decodeLine(ctx, null, stack, tree);
        tree.setMessage(parent);
        while (ctx.getBuffer().readableBytes() > 0 && (message = this.decodeLine(ctx, (DefaultTransaction)parent, stack, tree)) instanceof DefaultTransaction) {
            parent = message;
        }
    }

    @Override
    public ByteBuf encode(MessageTree tree) {
        ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.buffer(4096);
        int count = 0;
        int index = buf.writerIndex();
        buf.writeInt(0);
        count += this.encodeHeader(tree, buf);
        if (tree.getMessage() != null) {
            count += this.encodeMessage(tree.getMessage(), buf);
        }
        buf.setInt(index, count);
        return buf;
    }

    protected int encodeHeader(MessageTree tree, ByteBuf buf) {
        BufferHelper helper = this.bufferHelper;
        int count = 0;
        count += helper.write(buf, VERSION);
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getDomain());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getHostName());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getIpAddress());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getThreadGroupName());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getThreadId());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getThreadName());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getMessageId());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getParentMessageId());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getRootMessageId());
        count += helper.write(buf, (byte)9);
        count += helper.write(buf, tree.getSessionToken());
        return count += helper.write(buf, (byte)10);
    }

    private int encodeLine(Message message, ByteBuf buf, char type, Policy policy) {
        BufferHelper helper = this.bufferHelper;
        int count = 0;
        count += helper.write(buf, (byte)type);
        if (type == 'T' && message instanceof Transaction) {
            long duration = ((Transaction)message).getDurationInMillis();
            count += helper.write(buf, this.dateHelper.format(message.getTimestamp() + duration));
        } else {
            count += helper.write(buf, this.dateHelper.format(message.getTimestamp()));
        }
        count += helper.write(buf, (byte)9);
        count += helper.writeRaw(buf, message.getType());
        count += helper.write(buf, (byte)9);
        count += helper.writeRaw(buf, message.getName());
        count += helper.write(buf, (byte)9);
        if (policy != Policy.WITHOUT_STATUS) {
            count += helper.writeRaw(buf, message.getStatus());
            count += helper.write(buf, (byte)9);
            Object data = message.getData();
            if (policy == Policy.WITH_DURATION && message instanceof Transaction) {
                long duration = ((Transaction)message).getDurationInMicros();
                count += helper.write(buf, String.valueOf(duration));
                count += helper.write(buf, "us");
                count += helper.write(buf, (byte)9);
            }
            count += helper.writeRaw(buf, String.valueOf(data));
            count += helper.write(buf, (byte)9);
        }
        return count += helper.write(buf, (byte)10);
    }

    public int encodeMessage(Message message, ByteBuf buf) {
        if (message instanceof Transaction) {
            Transaction transaction = (Transaction)message;
            List<Message> children = transaction.getChildren();
            if (children.isEmpty()) {
                return this.encodeLine(transaction, buf, 'A', Policy.WITH_DURATION);
            }
            int count = 0;
            count += this.encodeLine(transaction, buf, 't', Policy.WITHOUT_STATUS);
            for (Message child : children) {
                if (child == null) continue;
                count += this.encodeMessage(child, buf);
            }
            return count += this.encodeLine(transaction, buf, 'T', Policy.WITH_DURATION);
        }
        if (message instanceof Event) {
            return this.encodeLine(message, buf, 'E', Policy.DEFAULT);
        }
        if (message instanceof Trace) {
            return this.encodeLine(message, buf, 'L', Policy.DEFAULT);
        }
        if (message instanceof Metric) {
            return this.encodeLine(message, buf, 'M', Policy.DEFAULT);
        }
        if (message instanceof Heartbeat) {
            return this.encodeLine(message, buf, 'H', Policy.DEFAULT);
        }
        throw new RuntimeException(String.format("Unsupported message type: %s.", message));
    }

    @Override
    public void reset() {
        if (this.ctx != null) {
            this.ctx.remove();
        }
    }

    protected void setBufferWriter(BufferWriter writer) {
        this.writer = writer;
        this.bufferHelper = new BufferHelper(this.writer);
    }

    protected static enum Policy {
        DEFAULT,
        WITHOUT_STATUS,
        WITH_DURATION;


        public static Policy getByMessageIdentifier(byte identifier) {
            switch (identifier) {
                case 116: {
                    return WITHOUT_STATUS;
                }
                case 65: 
                case 84: {
                    return WITH_DURATION;
                }
                case 69: 
                case 72: {
                    return DEFAULT;
                }
            }
            return DEFAULT;
        }
    }

    protected static class DateHelper {
        private BlockingQueue<SimpleDateFormat> m_formats = new ArrayBlockingQueue<SimpleDateFormat>(20);
        private Map<String, Long> m_map = new ConcurrentHashMap<String, Long>();

        protected DateHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String format(long timestamp) {
            SimpleDateFormat format = (SimpleDateFormat)this.m_formats.poll();
            if (format == null) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            }
            try {
                String string = format.format(new Date(timestamp));
                return string;
            }
            finally {
                if (this.m_formats.remainingCapacity() > 0) {
                    this.m_formats.offer(format);
                }
            }
        }

        public long parse(String str) {
            int len = str.length();
            String date = str.substring(0, 10);
            Long baseline = this.m_map.get(date);
            if (baseline == null) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    baseline = format.parse(date).getTime();
                    this.m_map.put(date, baseline);
                }
                catch (ParseException e) {
                    return -1L;
                }
            }
            long time = baseline;
            long metric = 1L;
            boolean millisecond = true;
            for (int i = len - 1; i > 10; --i) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    time += (long)(ch - 48) * metric;
                    metric *= 10L;
                    continue;
                }
                if (millisecond) {
                    millisecond = false;
                    continue;
                }
                metric = metric / 100L * 60L;
            }
            return time;
        }
    }

    public static class Context {
        private ByteBuf m_buffer;
        private char[] m_data = new char[0x100000];

        public ByteBuf getBuffer() {
            return this.m_buffer;
        }

        public char[] getData() {
            return this.m_data;
        }

        public Context setBuffer(ByteBuf buffer) {
            this.m_buffer = buffer;
            return this;
        }

        public void removeBuf() {
            this.m_buffer = null;
        }
    }

    protected static class BufferHelper {
        private BufferWriter m_writer;

        public BufferHelper(BufferWriter writer) {
            this.m_writer = writer;
        }

        public String read(Context ctx, byte separator) {
            byte b;
            ByteBuf buf = ctx.getBuffer();
            char[] data = ctx.getData();
            int from = buf.readerIndex();
            int to = buf.writerIndex();
            int index = 0;
            boolean flag = false;
            for (int i = from; i < to && (b = buf.readByte()) != separator; ++i) {
                int c;
                if (index >= data.length) {
                    char[] data2 = new char[to - from];
                    System.arraycopy(data, 0, data2, 0, index);
                    data = data2;
                }
                if ((c = (int)(b & 0xFF)) > 127) {
                    flag = true;
                }
                if (c == 92 && i + 1 < to) {
                    byte b2 = buf.readByte();
                    if (b2 == 116) {
                        c = 9;
                        ++i;
                    } else if (b2 == 114) {
                        c = 13;
                        ++i;
                    } else if (b2 == 110) {
                        c = 10;
                        ++i;
                    } else if (b2 == 92) {
                        c = 92;
                        ++i;
                    } else {
                        buf.readerIndex(i + 1);
                    }
                }
                data[index] = c;
                ++index;
            }
            if (!flag) {
                return new String(data, 0, index);
            }
            byte[] ba = new byte[index];
            for (int i = 0; i < index; ++i) {
                ba[i] = (byte)(data[i] & 0xFF);
            }
            try {
                return new String(ba, 0, index, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(ba, 0, index);
            }
        }

        public int write(ByteBuf buf, byte b) {
            buf.writeByte(b);
            return 1;
        }

        public int write(ByteBuf buf, String str) {
            if (str == null) {
                str = "null";
            }
            byte[] data = str.getBytes();
            buf.writeBytes(data);
            return data.length;
        }

        public int writeRaw(ByteBuf buf, String str) {
            byte[] data;
            if (str == null) {
                str = "null";
            }
            try {
                data = str.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                data = str.getBytes();
            }
            return this.m_writer.writeTo(buf, data);
        }
    }
}

