/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.internal.shaded.io.netty.buffer.ByteBuf;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.ForkableTransaction;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.codec.PlainTextMessageCodec;
import java.util.ArrayList;
import java.util.List;

public class DefaultMessageTree
implements MessageTree {
    private ByteBuf buf;
    private String domain;
    private String hostName;
    private String ipAddress;
    private Message message;
    private String messageId;
    private String parentMessageId;
    private String rootMessageId;
    private String sessionToken;
    private String threadGroupName;
    private String threadId;
    private String threadName;
    private MessageId formatMessageId;
    private boolean discard = true;
    private boolean hitSample = false;
    private List<Transaction> transactions;
    private List<Event> events;
    private List<Heartbeat> heartbeats;
    private List<Metric> metrics;
    private List<ForkableTransaction> forkableTransactions;

    @Override
    public synchronized void addForkableTransaction(ForkableTransaction forkableTransaction) {
        if (this.forkableTransactions == null) {
            this.forkableTransactions = new ArrayList<ForkableTransaction>();
        }
        this.forkableTransactions.add(forkableTransaction);
    }

    public void addHeartbeat(Heartbeat heartbeat) {
        if (this.heartbeats == null) {
            this.heartbeats = new ArrayList<Heartbeat>();
        }
        this.heartbeats.add(heartbeat);
    }

    @Override
    public boolean canDiscard() {
        return this.discard;
    }

    public void clearMessageList() {
        if (this.transactions != null) {
            this.transactions.clear();
        }
        if (this.events != null) {
            this.events.clear();
        }
        if (this.heartbeats != null) {
            this.heartbeats.clear();
        }
        if (this.metrics != null) {
            this.metrics.clear();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public MessageTree copy() {
        DefaultMessageTree tree = new DefaultMessageTree();
        tree.setDomain(this.domain);
        tree.setHostName(this.hostName);
        tree.setIpAddress(this.ipAddress);
        tree.setMessageId(this.messageId);
        tree.setParentMessageId(this.parentMessageId);
        tree.setRootMessageId(this.rootMessageId);
        tree.setSessionToken(this.sessionToken);
        tree.setThreadGroupName(this.threadGroupName);
        tree.setThreadId(this.threadId);
        tree.setThreadName(this.threadName);
        tree.setMessage(this.message);
        tree.setDiscardPrivate(this.discard);
        tree.setHitSample(this.hitSample);
        return tree;
    }

    public MessageTree copyForTest() {
        ByteBuf buf = null;
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = codec.encode(this);
            return codec.decode(buf);
        }
        catch (Exception ex) {
            Cat.logError(ex);
            return null;
        }
    }

    @Override
    public List<Event> findOrCreateEvents() {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        return this.events;
    }

    @Override
    public List<Heartbeat> findOrCreateHeartbeats() {
        if (this.heartbeats == null) {
            this.heartbeats = new ArrayList<Heartbeat>();
        }
        return this.heartbeats;
    }

    @Override
    public List<Metric> findOrCreateMetrics() {
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        }
        return this.metrics;
    }

    @Override
    public List<Transaction> findOrCreateTransactions() {
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
        }
        return this.transactions;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buf;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public List<ForkableTransaction> getForkableTransactions() {
        return this.forkableTransactions;
    }

    @Override
    public MessageId getFormatMessageId() {
        if (this.formatMessageId == null) {
            this.formatMessageId = MessageId.parse(this.messageId);
        }
        return this.formatMessageId;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getParentMessageId() {
        return this.parentMessageId;
    }

    @Override
    public String getRootMessageId() {
        return this.rootMessageId;
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public String getThreadGroupName() {
        return this.threadGroupName;
    }

    @Override
    public String getThreadId() {
        return this.threadId;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public boolean isHitSample() {
        return this.hitSample;
    }

    public void setBuffer(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public void setDiscardPrivate(boolean discard) {
        this.discard = discard;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void setFormatMessageId(MessageId formatMessageId) {
        this.formatMessageId = formatMessageId;
    }

    @Override
    public void setHitSample(boolean hitSample) {
        this.hitSample = hitSample;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public void setMessage(Message message) {
        this.message = message;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public void setParentMessageId(String parentMessageId) {
        this.parentMessageId = parentMessageId;
    }

    @Override
    public void setRootMessageId(String rootMessageId) {
        this.rootMessageId = rootMessageId;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public void setThreadGroupName(String threadGroupName) {
        this.threadGroupName = threadGroupName;
    }

    @Override
    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    @Override
    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String toString() {
        return PlainTextMessageCodec.encodeTree(this);
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public List<Heartbeat> getHeartbeats() {
        return this.heartbeats;
    }

    @Override
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    public List<Transaction> getTransactions() {
        return this.transactions;
    }
}

