/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.ApplicationEnvironment;
import com.dianping.cat.configuration.ClientConfigService;
import com.dianping.cat.configuration.DefaultClientConfigService;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.internal.shaded.io.netty.channel.ChannelFuture;
import com.dianping.cat.log.CatLogger;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultMessageProducer;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.io.ChannelManager;
import com.dianping.cat.status.StatusExtension;
import com.dianping.cat.status.StatusExtensionRegister;
import com.dianping.cat.status.datasource.c3p0.C3P0InfoCollector;
import com.dianping.cat.status.datasource.druid.DruidInfoCollector;
import com.dianping.cat.status.http.HttpStatsCollector;
import com.dianping.cat.status.jvm.ClassLoadingInfoCollector;
import com.dianping.cat.status.jvm.JvmInfoCollector;
import com.dianping.cat.status.jvm.ThreadInfoCollector;
import com.dianping.cat.status.jvm.ThreadInfoWriter;
import com.dianping.cat.status.model.entity.CustomInfo;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.StatusInfo;
import com.dianping.cat.status.system.ProcessorInfoCollector;
import com.dianping.cat.status.system.StaticInfoCollector;
import com.dianping.cat.util.Threads;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class StatusUpdateTask
implements Threads.Task {
    private ClientConfigService configService = DefaultClientConfigService.getInstance();
    private ChannelManager channelManager = ChannelManager.getInstance();
    private boolean active = true;
    private static CatLogger LOGGER = CatLogger.getInstance();

    public StatusUpdateTask() {
        this.initialize();
    }

    private void await() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExtenstion(StatusInfo status) {
        StatusExtensionRegister res = StatusExtensionRegister.getInstance();
        List<StatusExtension> extensions = res.getStatusExtension();
        for (StatusExtension extension : extensions) {
            Transaction t = Cat.newTransaction("System", "StatusExtension-" + extension.getId());
            try {
                Map<String, String> properties = extension.getProperties();
                if (properties.size() > 0) {
                    String id = extension.getId();
                    String des = extension.getDescription();
                    Extension item = status.findOrCreateExtension(id).setDescription(des);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        try {
                            double doubleValue = Double.parseDouble(value);
                            if (value.equalsIgnoreCase("NaN")) {
                                doubleValue = 0.0;
                            }
                            item.findOrCreateExtensionDetail(key).setValue(doubleValue);
                        }
                        catch (Exception e) {
                            status.getCustomInfos().put(key, new CustomInfo().setKey(key).setValue(value));
                        }
                    }
                }
                t.setSuccessStatus();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                t.setStatus(e);
            }
            finally {
                t.complete();
            }
        }
        ChannelFuture future = this.channelManager.channel();
        if (null != future) {
            String localAddress = future.channel().localAddress().toString();
            status.getCustomInfos().put("localAddress", new CustomInfo().setKey("localAddress").setValue(localAddress));
            status.getCustomInfos().put("env", new CustomInfo().setKey("env").setValue(ApplicationEnvironment.ENVIRONMENT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHeartbeat(String localHostAddress) {
        Transaction t = Cat.newTransaction("System", "Status");
        Heartbeat h = Cat.getProducer().newHeartbeat("Heartbeat", localHostAddress);
        StatusInfo status = new StatusInfo();
        Cat.getManager().getThreadLocalMessageTree().setDiscardPrivate(false);
        try {
            this.buildExtenstion(status);
            h.addData(status.toString());
            h.setStatus("0");
        }
        catch (Throwable e) {
            h.setStatus(e);
            Cat.logError(e);
        }
        finally {
            h.complete();
        }
        String eventName = this.calMinuteString();
        if (Cat.isJstackEnabled()) {
            Cat.logEvent("Heartbeat", "jstack." + eventName, "0", this.buildJstack());
        }
        t.setStatus("0");
        t.complete();
    }

    private String buildJstack() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        bean.setThreadContentionMonitoringEnabled(true);
        ThreadInfo[] threads = bean.dumpAllThreads(false, false);
        return new ThreadInfoWriter().buildThreadsInfo(threads);
    }

    private String calMinuteString() {
        Calendar cal = Calendar.getInstance();
        int minute = cal.get(12);
        String eventName = minute < 10 ? "jstack-0" + minute : "jstack-" + minute;
        return eventName;
    }

    private void clearCache() {
        DefaultTransaction.clearCache();
        DefaultMessageProducer.clearCache();
    }

    @Override
    public String getName() {
        return "heartbeat-task";
    }

    private void initialize() {
        try {
            JvmInfoCollector.getInstance().registerJVMCollector();
            StatusExtensionRegister instance = StatusExtensionRegister.getInstance();
            instance.register(new StaticInfoCollector());
            instance.register(new ClassLoadingInfoCollector());
            instance.register(new ThreadInfoCollector());
            if (!this.isDocker()) {
                instance.register(new ProcessorInfoCollector());
            }
            if (Cat.isDataSourceMonitorEnabled()) {
                instance.register(new C3P0InfoCollector());
                instance.register(new DruidInfoCollector());
            }
            instance.register(new HttpStatsCollector());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logMemoryBean();
    }

    private boolean isDocker() {
        File file = new File("/data/webapps/hulk");
        String hostname = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        return hostname.startsWith("set-") || file.exists();
    }

    private void logMemoryBean() {
        try {
            for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
                LOGGER.info("memory pool:" + memoryPool.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshClientConfig() {
        try {
            long current = System.currentTimeMillis() / 1000L / 60L;
            int min = (int)(current % 60L);
            if (min % 3 == 0) {
                this.configService.refreshConfig();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.await();
        String localHostAddress = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        Cat.logEvent("Reboot", localHostAddress, "0", null);
        while (this.active) {
            this.buildHeartbeat(localHostAddress);
            this.refreshClientConfig();
            this.clearCache();
            try {
                Calendar cal = Calendar.getInstance();
                cal.set(13, 20);
                cal.add(12, 1);
                long elapsed = cal.getTimeInMillis() - System.currentTimeMillis();
                if (elapsed <= 0L) continue;
                Thread.sleep(elapsed);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public void shutdown() {
        this.active = false;
    }
}

