/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.datasource;

import com.dianping.cat.status.AbstractCollector;
import com.dianping.cat.status.datasource.DatabaseParserHelper;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class DataSourceCollector
extends AbstractCollector {
    private Map<String, Object> lastValueMap = new HashMap<String, Object>();
    protected MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    protected DatabaseParserHelper databaseParser = new DatabaseParserHelper();
    protected static final char SPLIT = '.';
    private static final Integer ERROR_INT = -1;
    private static final Long ERROR_LONG = -1L;
    private static final String ERROR_ATTRIBUTE = "unknown";

    private Integer diffLast(String key, Integer value) {
        Object lastValue = this.lastValueMap.get(key);
        if (lastValue != null) {
            this.lastValueMap.put(key, value);
            return value - (Integer)lastValue;
        }
        this.lastValueMap.put(key, value);
        return value;
    }

    private Long diffLast(String key, Long value) {
        Object lastValue = this.lastValueMap.get(key);
        if (lastValue != null) {
            this.lastValueMap.put(key, value);
            return value - (Long)lastValue;
        }
        this.lastValueMap.put(key, value);
        return value;
    }

    protected String getConnection(Map<String, Integer> datasources, String key) {
        Integer index = datasources.get(key);
        if (index == null) {
            datasources.put(key, 0);
            return key;
        }
        Integer n = index;
        Integer n2 = index = Integer.valueOf(index + 1);
        datasources.put(key, index);
        return key + '[' + index + ']';
    }

    @Override
    public String getDescription() {
        return "datasource.c3p0";
    }

    @Override
    public String getId() {
        return "datasource.c3p0";
    }

    protected Integer getIntegerAttribute(ObjectName objectName, String attribute, Boolean isDiff) {
        try {
            Integer value = (Integer)this.mbeanServer.getAttribute(objectName, attribute);
            if (isDiff.booleanValue()) {
                return this.diffLast(objectName.getCanonicalName() + attribute, value);
            }
            return value;
        }
        catch (Exception e) {
            return ERROR_INT;
        }
    }

    protected Long getLongAttribute(ObjectName objectName, String attribute, Boolean isDiff) {
        try {
            Long value = (Long)this.mbeanServer.getAttribute(objectName, attribute);
            if (isDiff.booleanValue()) {
                return this.diffLast(objectName.getCanonicalName() + attribute, value);
            }
            return value;
        }
        catch (Exception e) {
            return ERROR_LONG;
        }
    }

    protected String getStringAttribute(ObjectName objectName, String attribute) {
        try {
            return (String)this.mbeanServer.getAttribute(objectName, attribute);
        }
        catch (Exception e) {
            return ERROR_ATTRIBUTE;
        }
    }

    protected Boolean isRandomName(String name) {
        return name != null && name.length() > 30;
    }
}

