/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.http;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HttpStats {
    private static HttpStats current = null;
    private AtomicInteger httpStatus400Count = new AtomicInteger();
    private AtomicInteger httpStatus500Count = new AtomicInteger();
    private AtomicInteger httpCount = new AtomicInteger();
    private AtomicLong httpTimeSum = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpStats currentStatsHolder() {
        if (null != current) return current;
        Class<HttpStats> clazz = HttpStats.class;
        synchronized (HttpStats.class) {
            if (null != current) return current;
            current = new HttpStats();
            // ** MonitorExit[var0] (shouldn't be in output)
            return current;
        }
    }

    public static synchronized HttpStats getAndReset() {
        HttpStats tmp = new HttpStats();
        HttpStats old = HttpStats.currentStatsHolder();
        current = tmp;
        return old;
    }

    private HttpStats() {
    }

    public void doRequestStats(long mills, int status) {
        try {
            if (this.is400(status)) {
                this.httpStatus400Count.incrementAndGet();
            } else if (this.is500(status)) {
                this.httpStatus500Count.incrementAndGet();
            }
            this.httpCount.incrementAndGet();
            this.httpTimeSum.addAndGet(mills);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHttpCount() {
        return this.httpCount.get();
    }

    public int getHttpMeantime() {
        long meantime = 0 == this.httpCount.get() ? 0L : this.httpTimeSum.get() / (long)this.httpCount.get();
        return (int)meantime;
    }

    public int getHttpStatus400Count() {
        return this.httpStatus400Count.get();
    }

    public int getHttpStatus500Count() {
        return this.httpStatus500Count.get();
    }

    private boolean is400(int status) {
        return status >= 400 && status < 500;
    }

    private boolean is500(int status) {
        return status >= 500;
    }
}

