/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;
import com.dianping.cat.status.model.entity.ExtensionDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class Extension
extends BaseEntity<Extension> {
    private String id;
    private String description;
    private final Map<String, ExtensionDetail> details = new LinkedHashMap<String, ExtensionDetail>();
    private Map<String, String> dynamicAttributes = new LinkedHashMap<String, String>();

    public Extension() {
    }

    public Extension(String id) {
        this.id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitExtension(this);
    }

    public Extension addExtensionDetail(ExtensionDetail extensionDetail) {
        this.details.put(extensionDetail.getId(), extensionDetail);
        return this;
    }

    public ExtensionDetail findExtensionDetail(String id) {
        return this.details.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionDetail findOrCreateExtensionDetail(String id) {
        ExtensionDetail extensionDetail = this.details.get(id);
        if (extensionDetail == null) {
            Map<String, ExtensionDetail> map = this.details;
            synchronized (map) {
                extensionDetail = this.details.get(id);
                if (extensionDetail == null) {
                    extensionDetail = new ExtensionDetail(id);
                    this.details.put(id, extensionDetail);
                }
            }
        }
        return extensionDetail;
    }

    @Override
    public void mergeAttributes(Extension other) {
        this.assertAttributeEquals(other, "extension", "id", this.id, other.getId());
        for (Map.Entry<String, String> e : other.getDynamicAttributes().entrySet()) {
            this.dynamicAttributes.put(e.getKey(), e.getValue());
        }
    }

    public boolean removeExtensionDetail(String id) {
        if (this.details.containsKey(id)) {
            this.details.remove(id);
            return true;
        }
        return false;
    }

    public void setDynamicAttribute(String name, String value) {
        this.dynamicAttributes.put(name, value);
    }

    public Extension setDescription(String description) {
        this.description = description;
        return this;
    }

    public Extension setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, ExtensionDetail> getDetails() {
        return this.details;
    }

    public Map<String, String> getDynamicAttributes() {
        return this.dynamicAttributes;
    }

    public void setDynamicAttributes(Map<String, String> dynamicAttributes) {
        this.dynamicAttributes = dynamicAttributes;
    }

    @Override
    public String toString() {
        return "Extension(id=" + this.getId() + ", description=" + this.getDescription() + ", details=" + this.getDetails() + ", dynamicAttributes=" + this.getDynamicAttributes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension other = (Extension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, ExtensionDetail> this$details = this.getDetails();
        Map<String, ExtensionDetail> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        Map<String, String> this$dynamicAttributes = this.getDynamicAttributes();
        Map<String, String> other$dynamicAttributes = other.getDynamicAttributes();
        return !(this$dynamicAttributes == null ? other$dynamicAttributes != null : !((Object)this$dynamicAttributes).equals(other$dynamicAttributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Extension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, ExtensionDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        Map<String, String> $dynamicAttributes = this.getDynamicAttributes();
        result = result * 59 + ($dynamicAttributes == null ? 43 : ((Object)$dynamicAttributes).hashCode());
        return result;
    }
}

