/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;

public class MessageInfo
extends BaseEntity<MessageInfo> {
    private long produced;
    private long overflowed;
    private long bytes;

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitMessage(this);
    }

    @Override
    public void mergeAttributes(MessageInfo other) {
        this.produced = other.getProduced();
        this.overflowed = other.getOverflowed();
        this.bytes = other.getBytes();
    }

    public MessageInfo setBytes(long bytes) {
        this.bytes = bytes;
        return this;
    }

    public MessageInfo setOverflowed(long overflowed) {
        this.overflowed = overflowed;
        return this;
    }

    public MessageInfo setProduced(long produced) {
        this.produced = produced;
        return this;
    }

    public long getProduced() {
        return this.produced;
    }

    public long getOverflowed() {
        return this.overflowed;
    }

    public long getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return "MessageInfo(produced=" + this.getProduced() + ", overflowed=" + this.getOverflowed() + ", bytes=" + this.getBytes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageInfo)) {
            return false;
        }
        MessageInfo other = (MessageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getProduced() != other.getProduced()) {
            return false;
        }
        if (this.getOverflowed() != other.getOverflowed()) {
            return false;
        }
        return this.getBytes() == other.getBytes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $produced = this.getProduced();
        result = result * 59 + (int)($produced >>> 32 ^ $produced);
        long $overflowed = this.getOverflowed();
        result = result * 59 + (int)($overflowed >>> 32 ^ $overflowed);
        long $bytes = this.getBytes();
        result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
        return result;
    }
}

