/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;

public class OsInfo
extends BaseEntity<OsInfo> {
    private String name;
    private String arch;
    private String version;
    private int availableProcessors;
    private double systemLoadAverage;
    private long processTime;
    private long totalPhysicalMemory;
    private long freePhysicalMemory;
    private long committedVirtualMemory;
    private long totalSwapSpace;
    private long freeSwapSpace;

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitOs(this);
    }

    @Override
    public void mergeAttributes(OsInfo other) {
        if (other.getName() != null) {
            this.name = other.getName();
        }
        if (other.getArch() != null) {
            this.arch = other.getArch();
        }
        if (other.getVersion() != null) {
            this.version = other.getVersion();
        }
        this.availableProcessors = other.getAvailableProcessors();
        this.systemLoadAverage = other.getSystemLoadAverage();
        this.processTime = other.getProcessTime();
        this.totalPhysicalMemory = other.getTotalPhysicalMemory();
        this.freePhysicalMemory = other.getFreePhysicalMemory();
        this.committedVirtualMemory = other.getCommittedVirtualMemory();
        this.totalSwapSpace = other.getTotalSwapSpace();
        this.freeSwapSpace = other.getFreeSwapSpace();
    }

    public OsInfo setArch(String arch) {
        this.arch = arch;
        return this;
    }

    public OsInfo setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
        return this;
    }

    public OsInfo setCommittedVirtualMemory(long committedVirtualMemory) {
        this.committedVirtualMemory = committedVirtualMemory;
        return this;
    }

    public OsInfo setFreePhysicalMemory(long freePhysicalMemory) {
        this.freePhysicalMemory = freePhysicalMemory;
        return this;
    }

    public OsInfo setFreeSwapSpace(long freeSwapSpace) {
        this.freeSwapSpace = freeSwapSpace;
        return this;
    }

    public OsInfo setName(String name) {
        this.name = name;
        return this;
    }

    public OsInfo setProcessTime(long processTime) {
        this.processTime = processTime;
        return this;
    }

    public OsInfo setSystemLoadAverage(double systemLoadAverage) {
        this.systemLoadAverage = systemLoadAverage;
        return this;
    }

    public OsInfo setTotalPhysicalMemory(long totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
        return this;
    }

    public OsInfo setTotalSwapSpace(long totalSwapSpace) {
        this.totalSwapSpace = totalSwapSpace;
        return this;
    }

    public OsInfo setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    public long getProcessTime() {
        return this.processTime;
    }

    public long getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public long getFreePhysicalMemory() {
        return this.freePhysicalMemory;
    }

    public long getCommittedVirtualMemory() {
        return this.committedVirtualMemory;
    }

    public long getTotalSwapSpace() {
        return this.totalSwapSpace;
    }

    public long getFreeSwapSpace() {
        return this.freeSwapSpace;
    }

    @Override
    public String toString() {
        return "OsInfo(name=" + this.getName() + ", arch=" + this.getArch() + ", version=" + this.getVersion() + ", availableProcessors=" + this.getAvailableProcessors() + ", systemLoadAverage=" + this.getSystemLoadAverage() + ", processTime=" + this.getProcessTime() + ", totalPhysicalMemory=" + this.getTotalPhysicalMemory() + ", freePhysicalMemory=" + this.getFreePhysicalMemory() + ", committedVirtualMemory=" + this.getCommittedVirtualMemory() + ", totalSwapSpace=" + this.getTotalSwapSpace() + ", freeSwapSpace=" + this.getFreeSwapSpace() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OsInfo)) {
            return false;
        }
        OsInfo other = (OsInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$arch = this.getArch();
        String other$arch = other.getArch();
        if (this$arch == null ? other$arch != null : !this$arch.equals(other$arch)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (this.getAvailableProcessors() != other.getAvailableProcessors()) {
            return false;
        }
        if (Double.compare(this.getSystemLoadAverage(), other.getSystemLoadAverage()) != 0) {
            return false;
        }
        if (this.getProcessTime() != other.getProcessTime()) {
            return false;
        }
        if (this.getTotalPhysicalMemory() != other.getTotalPhysicalMemory()) {
            return false;
        }
        if (this.getFreePhysicalMemory() != other.getFreePhysicalMemory()) {
            return false;
        }
        if (this.getCommittedVirtualMemory() != other.getCommittedVirtualMemory()) {
            return false;
        }
        if (this.getTotalSwapSpace() != other.getTotalSwapSpace()) {
            return false;
        }
        return this.getFreeSwapSpace() == other.getFreeSwapSpace();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OsInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $arch = this.getArch();
        result = result * 59 + ($arch == null ? 43 : $arch.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + this.getAvailableProcessors();
        long $systemLoadAverage = Double.doubleToLongBits(this.getSystemLoadAverage());
        result = result * 59 + (int)($systemLoadAverage >>> 32 ^ $systemLoadAverage);
        long $processTime = this.getProcessTime();
        result = result * 59 + (int)($processTime >>> 32 ^ $processTime);
        long $totalPhysicalMemory = this.getTotalPhysicalMemory();
        result = result * 59 + (int)($totalPhysicalMemory >>> 32 ^ $totalPhysicalMemory);
        long $freePhysicalMemory = this.getFreePhysicalMemory();
        result = result * 59 + (int)($freePhysicalMemory >>> 32 ^ $freePhysicalMemory);
        long $committedVirtualMemory = this.getCommittedVirtualMemory();
        result = result * 59 + (int)($committedVirtualMemory >>> 32 ^ $committedVirtualMemory);
        long $totalSwapSpace = this.getTotalSwapSpace();
        result = result * 59 + (int)($totalSwapSpace >>> 32 ^ $totalSwapSpace);
        long $freeSwapSpace = this.getFreeSwapSpace();
        result = result * 59 + (int)($freeSwapSpace >>> 32 ^ $freeSwapSpace);
        return result;
    }
}

